/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.world.storage;

import io.github.tehstoneman.betterstorage.api.ICrateStorage;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class CrateStorage
implements ICrateStorage {
    private final Map<UUID, CrateStackHandler> pileDataMap = new HashMap<UUID, CrateStackHandler>();

    @Override
    public CrateStackHandler getCratePile(UUID pileID) {
        if (pileID != null && this.pileDataMap.containsKey(pileID)) {
            return this.pileDataMap.get(pileID);
        }
        return this.createCratePile();
    }

    @Override
    public CrateStackHandler getOrCreateCratePile(UUID pileID) {
        if (!this.pileDataMap.containsKey(pileID)) {
            CrateStackHandler cratePile = new CrateStackHandler(18);
            this.pileDataMap.put(pileID, cratePile);
        }
        return this.pileDataMap.get(pileID);
    }

    @Override
    public CrateStackHandler createCratePile() {
        UUID pileID = UUID.randomUUID();
        while (this.pileDataMap.containsKey(pileID)) {
            pileID = UUID.randomUUID();
        }
        return this.addCrateToPile(pileID);
    }

    @Override
    public CrateStackHandler addCrateToPile(UUID pileID) {
        CrateStackHandler cratePile = new CrateStackHandler(18);
        this.pileDataMap.put(pileID, cratePile);
        cratePile.setPileID(pileID);
        return cratePile;
    }

    @Override
    public void removeCratePile(UUID pileID) {
        this.pileDataMap.remove(pileID);
    }

    public CompoundNBT serializeNBT() {
        Logger.getLogger("betterstorage").info("Saving crate storage");
        CompoundNBT compound = new CompoundNBT();
        if (!this.pileDataMap.isEmpty()) {
            for (Map.Entry<UUID, CrateStackHandler> entry : this.pileDataMap.entrySet()) {
                compound.func_218657_a(entry.getKey().toString(), (INBT)entry.getValue().serializeNBT());
            }
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        Logger.getLogger("betterstorage").info("Loading crate storage");
        if (!compound.isEmpty()) {
            for (String key : compound.func_150296_c()) {
                CrateStackHandler crateStackHandler = new CrateStackHandler(18);
                crateStackHandler.deserializeNBT(compound.func_74775_l(key));
                this.pileDataMap.put(UUID.fromString(key), crateStackHandler);
            }
        }
    }
}

