/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class BetterStorageConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static Common COMMON = new Common(COMMON_BUILDER);
    private static ForgeConfigSpec COMMON_SPEC = COMMON_BUILDER.build();

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    public static class Common {
        public ForgeConfigSpec.IntValue reinforcedColumns;
        public ForgeConfigSpec.BooleanValue crateAllowAutomation;
        public ForgeConfigSpec.IntValue cardboardBoxRows;
        public ForgeConfigSpec.IntValue cardboardBoxUses;
        public ForgeConfigSpec.BooleanValue cardboardBoxShowContents;
        public ForgeConfigSpec.BooleanValue cardboardBoxPistonBreakable;
        public ForgeConfigSpec.BooleanValue cardboardBoxDispenserPlaceable;
        public ForgeConfigSpec.BooleanValue lockBreakable;
        public ForgeConfigSpec.IntValue tankBuckets;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings.").push("General");
            this.reinforcedColumns = builder.comment("Number of columns in reinforced chests and lockers.").translation("config.betterstorage.general.reinforcedColumns").defineInRange("reinforcedColumns", 13, 9, 13);
            this.crateAllowAutomation = builder.comment("Allow atomation to access the contents of crates.").translation("config.betterstorage.general.crateAllowAutomation").define("crateAllowAutomation", true);
            this.cardboardBoxRows = builder.comment("Number of rows in cardboard boxes.").translation("config.betterstorage.general.cardboardBoxRows").defineInRange("cardboardBoxRows", 3, 1, 3);
            this.cardboardBoxUses = builder.comment("Number of times cardboard boxes can be picked up with items before they break. Use 0 for infinite uses.").translation("config.betterstorage.general.cardboardBoxUses").defineInRange("cardboardBoxUses", 25, 0, Integer.MAX_VALUE);
            this.cardboardBoxShowContents = builder.comment("If disabled, doesn't show cardboard box contents in their tooltips.").translation("config.betterstorage.general.cardboardBoxShowContents").define("cardboardBoxShowContents", true);
            this.cardboardBoxPistonBreakable = builder.comment("Allow pistons to break cardboard boxes.").translation("config.betterstorage.general.cardboardBoxPistonBreakable").define("cardboardBoxPistonBreakable", true);
            this.cardboardBoxDispenserPlaceable = builder.comment("Allow dispensers to place cardboard boxes.").translation("config.betterstorage.general.cardboardBoxDispenserPlaceable").define("cardboardBoxDispenserPlaceable", true);
            this.lockBreakable = builder.comment("Allow locked blocks to be breakable.").translation("config.betterstorage.general.lockBreakable").define("lockBreakable", true);
            this.tankBuckets = builder.comment("Number of buckets that one tank can hold.").translation("config.betterstorage.general.tankBuckets").defineInRange("tankBuckets", 16, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

