/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.event;

import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterstorage")
public class BetterStorageEventHandler {
    @SubscribeEvent
    public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
        IKeyLockable lockable;
        PlayerEntity player;
        World world;
        TileEntity tileEntity;
        BlockState blockState = event.getState();
        BlockPos pos = event.getPos();
        if (blockState.hasTileEntity() && (tileEntity = (world = (player = event.getPlayer()).func_130014_f_()).func_175625_s(event.getPos())) instanceof IKeyLockable && (lockable = (IKeyLockable)tileEntity) != null && lockable.isLocked()) {
            if (((Boolean)BetterStorageConfig.COMMON.lockBreakable.get()).booleanValue()) {
                ItemStack tool = player.func_184614_ca();
                Set toolTypes = tool.getToolTypes();
                float speed = event.getOriginalSpeed() * 0.2f;
                if (!toolTypes.contains(ToolType.AXE) && !toolTypes.contains(ToolType.PICKAXE)) {
                    speed *= 0.1f;
                } else {
                    int level = Math.max(tool.getHarvestLevel(ToolType.AXE, player, blockState), tool.getHarvestLevel(ToolType.PICKAXE, player, blockState));
                    if (level < EnchantmentHelper.func_77506_a((Enchantment)EnchantmentBetterStorage.PERSISTANCE, (ItemStack)lockable.getLock())) {
                        speed *= 0.1f;
                    }
                }
                event.setNewSpeed(speed);
            } else if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }
}

