/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.fluid.BetterStorageFluids;
import io.github.tehstoneman.betterstorage.common.fluid.FluidMilk;
import io.github.tehstoneman.betterstorage.common.inventory.BetterStorageContainerTypes;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItemGroup;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import io.github.tehstoneman.betterstorage.network.ModNetwork;
import io.github.tehstoneman.betterstorage.proxy.ClientProxy;
import io.github.tehstoneman.betterstorage.proxy.IProxy;
import io.github.tehstoneman.betterstorage.proxy.ServerProxy;
import java.util.Random;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="betterstorage")
public class BetterStorage {
    public static final Logger LOGGER = LogManager.getLogger((String)"betterstorage");
    public static final ItemGroup ITEM_GROUP = new BetterStorageItemGroup();
    public static final SimpleChannel NETWORK = ModNetwork.getNetworkChannel();
    public static final IProxy PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static Random RANDOM;

    public BetterStorage() {
        RANDOM = new Random();
        BetterStorageConfig.register(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BetterStorageBlocks.REGISTERY.register(modEventBus);
        BetterStorageFluids.REGISTERY.register(modEventBus);
        BetterStorageItems.REGISTERY.register(modEventBus);
        EnchantmentBetterStorage.REGISTERY.register(modEventBus);
        BetterStorageTileEntityTypes.REGISTERY.register(modEventBus);
        BetterStorageContainerTypes.REGISTERY.register(modEventBus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            if (((Boolean)BetterStorageConfig.COMMON.cardboardBoxDispenserPlaceable.get()).booleanValue()) {
                DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)BetterStorageBlocks.CARDBOARD_BOX.get()), (IDispenseItemBehavior)new OptionalDispenseBehavior(){

                    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                        this.field_218407_b = false;
                        Item item = stack.func_77973_b();
                        if (item instanceof BlockItem) {
                            Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                            Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
                            this.field_218407_b = ((BlockItem)item).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext(source.func_197524_h(), blockpos, direction, stack, direction1)) == ActionResultType.SUCCESS;
                        }
                        return stack;
                    }
                });
            }
            if (((Boolean)BetterStorageConfig.COMMON.useFluidMilk.get()).booleanValue()) {
                DispenserBlock.func_199774_a((IItemProvider)Items.field_151117_aB, (IDispenseItemBehavior)new OptionalDispenseBehavior(){
                    private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

                    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                        Item bucketitem = stack.func_77973_b();
                        BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                        World world = source.func_197524_h();
                        if (FluidMilk.tryPlaceContainedLiquid(bucketitem, null, world, blockpos, null)) {
                            return new ItemStack((IItemProvider)Items.field_151133_ar);
                        }
                        return this.dispenseBehavior.dispense(source, stack);
                    }
                });
            }
        });
    }
}

