/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.api;

import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IDyeableItem {
    default public boolean canDye(ItemStack itemStack) {
        return true;
    }

    default public boolean hasColor(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            CompoundNBT compound = itemStack.func_77978_p();
            return compound.func_74764_b("Color");
        }
        return false;
    }

    default public int getColor(ItemStack itemStack) {
        if (this.hasColor(itemStack)) {
            CompoundNBT compound = itemStack.func_77978_p();
            return compound.func_74762_e("Color");
        }
        return this.getDefaultColor();
    }

    public int getDefaultColor();

    default public void setColor(ItemStack itemStack, int colorRGB) {
        CompoundNBT compound = itemStack.func_196082_o();
        compound.func_74768_a("Color", colorRGB);
        itemStack.func_77982_d(compound);
    }

    public static ItemStack dyeItem(ItemStack itemStack, List<DyeColor> dyeList) {
        ItemStack restuleStacktack = ItemStack.field_190927_a;
        int[] aint = new int[3];
        int i = 0;
        int count = 0;
        IDyeableItem dyeableItem = null;
        Item item = itemStack.func_77973_b();
        if (item instanceof IDyeableItem) {
            dyeableItem = (IDyeableItem)item;
            restuleStacktack = itemStack.func_77946_l();
            restuleStacktack.func_190920_e(1);
            if (dyeableItem.hasColor(itemStack)) {
                int color = dyeableItem.getColor(restuleStacktack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(r, Math.max(g, b)) * 255.0f);
                aint[0] = (int)((float)aint[0] + r * 255.0f);
                aint[1] = (int)((float)aint[1] + g * 255.0f);
                aint[2] = (int)((float)aint[2] + b * 255.0f);
                ++count;
            }
            for (DyeColor dyeitem : dyeList) {
                float[] afloat = dyeitem.func_193349_f();
                int r = (int)(afloat[0] * 255.0f);
                int g = (int)(afloat[1] * 255.0f);
                int b = (int)(afloat[2] * 255.0f);
                i += Math.max(r, Math.max(g, b));
                aint[0] = aint[0] + r;
                aint[1] = aint[1] + g;
                aint[2] = aint[2] + b;
                ++count;
            }
        }
        if (dyeableItem == null) {
            return ItemStack.field_190927_a;
        }
        int r = aint[0] / count;
        int g = aint[1] / count;
        int b = aint[2] / count;
        float f3 = (float)i / (float)count;
        float f4 = Math.max(r, Math.max(g, b));
        r = (int)((float)r * f3 / f4);
        g = (int)((float)g * f3 / f4);
        b = (int)((float)b * f3 / f4);
        int j2 = (r << 8) + g;
        j2 = (j2 << 8) + b;
        dyeableItem.setColor(restuleStacktack, j2);
        return restuleStacktack;
    }
}

