/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.client.renderer.Resources;
import io.github.tehstoneman.betterstorage.client.renderer.tileentity.model.ModelLargeLocker;
import io.github.tehstoneman.betterstorage.client.renderer.tileentity.model.ModelLocker;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.block.BlockLocker;
import io.github.tehstoneman.betterstorage.common.block.BlockReinforcedChest;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLocker;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import io.github.tehstoneman.betterstorage.util.BetterStorageResource;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class TileEntityLockerRenderer
extends TileEntityRenderer<TileEntityLocker> {
    private final ModelLocker simpleLocker = new ModelLocker();
    private final ModelLocker largeLocker = new ModelLargeLocker();
    private HexKeyConfig config;
    private ItemRenderer itemRenderer;
    private static BlockRendererDispatcher blockRenderer;
    private static ModelManager modelManager;

    public TileEntityLockerRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityLocker tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState blockState = tileEntity.func_145830_o() ? tileEntity.func_195044_w() : (BlockState)((BlockLocker)BetterStorageBlocks.LOCKER.get()).func_176223_P().func_206870_a((IProperty)BlockLocker.FACING, (Comparable)Direction.SOUTH);
        ConnectedType lockerType = blockState.func_196959_b(BlockConnectableContainer.TYPE) ? (ConnectedType)((Object)blockState.func_177229_b(BlockConnectableContainer.TYPE)) : ConnectedType.SINGLE;
        DoorHingeSide hingeSide = blockState.func_196959_b((IProperty)BlockStateProperties.field_208142_aq) ? (DoorHingeSide)blockState.func_177229_b((IProperty)BlockStateProperties.field_208142_aq) : DoorHingeSide.LEFT;
        Direction facing = (Direction)blockState.func_177229_b((IProperty)BlockReinforcedChest.FACING);
        if (lockerType != ConnectedType.SLAVE) {
            boolean flag;
            if (tileEntity instanceof TileEntityReinforcedLocker) {
                this.config = ((TileEntityReinforcedLocker)tileEntity).getConfig();
            }
            boolean bl = flag = lockerType != ConnectedType.SINGLE;
            if (blockRenderer == null) {
                blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            }
            if (modelManager == null) {
                modelManager = Minecraft.func_71410_x().func_209506_al();
            }
            matrixStack.func_227860_a_();
            float f = facing.func_185119_l();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            if (tileEntity instanceof TileEntityReinforcedLocker && ((Boolean)BetterStorageConfig.CLIENT.useObjModels.get()).booleanValue()) {
                Item item;
                IBakedModel modelBase = modelManager.getModel((ResourceLocation)(lockerType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_LOCKER : Resources.MODEL_REINFORCED_LOCKER_LARGE));
                IBakedModel modelDoor = modelManager.getModel((ResourceLocation)(lockerType == ConnectedType.SINGLE ? (hingeSide == DoorHingeSide.LEFT ? Resources.MODEL_REINFORCED_LOCKER_DOOR_L : Resources.MODEL_REINFORCED_LOCKER_DOOR_R) : (hingeSide == DoorHingeSide.LEFT ? Resources.MODEL_REINFORCED_LOCKER_DOOR_LARGE_L : Resources.MODEL_REINFORCED_LOCKER_DOOR_LARGE_R)));
                IBakedModel modelFrame = modelManager.getModel((ResourceLocation)(lockerType == ConnectedType.SINGLE ? Resources.MODEL_REINFORCED_LOCKER_FRAME : Resources.MODEL_REINFORCED_LOCKER_LARGE_FRAME));
                IBakedModel modelDoorFrame = modelManager.getModel((ResourceLocation)(lockerType == ConnectedType.SINGLE ? (hingeSide == DoorHingeSide.LEFT ? Resources.MODEL_REINFORCED_LOCKER_DOOR_FRAME_L : Resources.MODEL_REINFORCED_LOCKER_DOOR_FRAME_R) : (hingeSide == DoorHingeSide.LEFT ? Resources.MODEL_REINFORCED_LOCKER_DOOR_LARGE_FRAME_L : Resources.MODEL_REINFORCED_LOCKER_DOOR_LARGE_FRAME_R)));
                World world = tileEntity.func_145831_w();
                BlockPos pos = tileEntity.func_174877_v();
                ChunkRenderCache lightReader = MinecraftForgeClient.getRegionRenderCache((World)world, (BlockPos)pos);
                long random = blockState.func_209533_a(pos);
                IVertexBuilder renderBufferLocker = buffer.getBuffer(Atlases.func_228782_g_());
                Material material = new Material(PlayerContainer.field_226615_c_, (ResourceLocation)Resources.TEXTURE_REINFORCED_FRAME);
                ItemStack itemStack = this.config.getStackInSlot(HexKeyConfig.SLOT_APPEARANCE);
                if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) instanceof BlockItem) {
                    BlockState state = ((BlockItem)item).func_179223_d().func_176223_P();
                    TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, world, pos);
                    material = new Material(PlayerContainer.field_226615_c_, texture.func_195668_m());
                }
                IVertexBuilder renderBufferFrame = material.func_229311_a_(buffer, RenderType::func_228634_a_);
                IModelData data = modelBase.getModelData((ILightReader)world, pos, blockState, ModelDataManager.getModelData((World)world, (BlockPos)pos));
                MatrixStack.Entry currentMatrix = matrixStack.func_227866_c_();
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferLocker, null, modelBase, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferFrame, null, modelFrame, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                this.rotateDoor(tileEntity, partialTicks, matrixStack, hingeSide);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferLocker, null, modelDoor, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                blockRenderer.func_175019_b().renderModel(currentMatrix, renderBufferFrame, null, modelDoorFrame, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, data);
                matrixStack.func_227861_a_(hingeSide == DoorHingeSide.LEFT ? 0.0 : -1.0, 0.0, -0.8125);
            } else {
                ModelLocker modelLocker = this.getLockerModel(tileEntity, flag);
                Material material = this.getMaterial(tileEntity, flag);
                IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
                this.rotateDoor(tileEntity, partialTicks, modelLocker, hingeSide);
                modelLocker.render(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, hingeSide == DoorHingeSide.LEFT);
            }
            if (tileEntity instanceof TileEntityReinforcedLocker) {
                this.renderItem((TileEntityReinforcedLocker)tileEntity, partialTicks, matrixStack, buffer, combinedLight, blockState);
            }
            matrixStack.func_227865_b_();
        }
    }

    private ModelLocker getLockerModel(TileEntityLocker tileEntityLocker, boolean flag) {
        return flag ? this.largeLocker : this.simpleLocker;
    }

    protected Material getMaterial(TileEntityLocker tileEntity, boolean flag) {
        BetterStorageResource resourcelocation = tileEntity instanceof TileEntityReinforcedLocker ? (flag ? Resources.TEXTURE_LOCKER_REINFORCED_DOUBLE : Resources.TEXTURE_LOCKER_REINFORCED) : (flag ? Resources.TEXTURE_LOCKER_NORMAL_DOUBLE : Resources.TEXTURE_LOCKER_NORMAL);
        return new Material(PlayerContainer.field_226615_c_, (ResourceLocation)resourcelocation);
    }

    private void rotateDoor(TileEntityLocker tileEntityLocker, float partialTicks, ModelLocker modelLocker, DoorHingeSide hingeSide) {
        float angle = tileEntityLocker.func_195480_a(partialTicks);
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        modelLocker.rotateDoor(angle, hingeSide == DoorHingeSide.LEFT);
    }

    private void rotateDoor(TileEntityLocker tileEntityLocker, float partialTicks, MatrixStack matrixStack, DoorHingeSide hingeSide) {
        float angle = tileEntityLocker.func_195480_a(partialTicks);
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        matrixStack.func_227861_a_(hingeSide == DoorHingeSide.LEFT ? 0.0 : 1.0, 0.0, 0.8125);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(hingeSide == DoorHingeSide.LEFT ? -angle : angle));
    }

    private void renderItem(TileEntityReinforcedLocker locker, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, BlockState state) {
        ItemStack itemstack = locker.getLock();
        if (!itemstack.func_190926_b()) {
            if (this.itemRenderer == null) {
                this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }
            float openAngle = locker.func_195480_a(partialTicks);
            openAngle = 1.0f - openAngle;
            openAngle = 1.0f - openAngle * openAngle * openAngle;
            boolean left = state.func_177229_b((IProperty)DoorBlock.field_176521_M) == DoorHingeSide.LEFT;
            matrixStack.func_227861_a_(0.0, 0.0, 0.8125);
            matrixStack.func_227861_a_(left ? 0.0 : 1.0, 0.0, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(left ? -openAngle * 90.0f : openAngle * 90.0f));
            matrixStack.func_227861_a_(left ? -0.0 : -1.0, 0.0, 0.0);
            matrixStack.func_227861_a_(left ? 0.8125 : 0.1875, locker.isConnected() ? 0.875 : 0.375, 0.125);
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
        }
    }
}

