/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.tehstoneman.betterstorage.client.renderer.Resources;
import io.github.tehstoneman.betterstorage.client.renderer.tileentity.model.ModelTankFluid;
import io.github.tehstoneman.betterstorage.common.block.BlockTank;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityTank;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityTankRenderer
extends TileEntityRenderer<TileEntityTank> {
    private final ModelTankFluid tankFluidModel = new ModelTankFluid();

    public TileEntityTankRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityTank tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        int capacity = tileEntity.getCapacity();
        FluidStack fluidStack = tileEntity.getFluid();
        Fluid fluid = fluidStack.getFluid();
        if (!fluidStack.isEmpty()) {
            matrixStack.func_227860_a_();
            double posY = 0.0625 + 0.875 * (double)((float)fluidStack.getAmount() / (float)capacity);
            MaterialColor mapColor = fluid.func_207188_f().func_206883_i().func_185904_a().func_151565_r();
            int color = mapColor.field_76291_p;
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            BlockPos pos = tileEntity.func_174877_v();
            BlockState blockState = tileEntity.func_195044_w();
            Material material = new Material(PlayerContainer.field_226615_c_, (ResourceLocation)Resources.TEXTURE_WHITE);
            IVertexBuilder vertexBuilder = material.func_229311_a_(buffer, RenderType::func_228638_b_);
            this.tankFluidModel.setLevel((float)fluidStack.getAmount() / (float)capacity, (Boolean)blockState.func_177229_b((IProperty)BlockTank.UP), (Boolean)blockState.func_177229_b((IProperty)BlockTank.DOWN), fluid.getAttributes().isLighterThanAir());
            this.tankFluidModel.func_225598_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, red, green, blue, 1.0f);
            matrixStack.func_227865_b_();
        }
    }
}

