/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockableDoor;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockLockableDoor
extends Block {
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public BlockLockableDoor() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150454_av));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DoorBlock.field_176520_a, (Comparable)Direction.NORTH)).func_206870_a((IProperty)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DoorBlock.field_176521_M, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)DoorBlock.field_176520_a);
        boolean open = (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b) == false;
        boolean hinge = state.func_177229_b((IProperty)DoorBlock.field_176521_M) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return open ? EAST_AABB : (hinge ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return open ? SOUTH_AABB : (hinge ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return open ? WEST_AABB : (hinge ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return open ? NORTH_AABB : (hinge ? WEST_AABB : EAST_AABB);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity;
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        if ((tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityLockableDoor) {
            TileEntityLockableDoor tileDoor = (TileEntityLockableDoor)tileentity;
            if (!tileDoor.unlockWith(player.func_184586_b(handIn))) {
                ItemStack lock = tileDoor.getLock();
                ((ILock)lock.func_77973_b()).applyEffects(lock, tileDoor, player, LockInteraction.OPEN);
                return ActionResultType.PASS;
            }
            if (player.func_213453_ef()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tileDoor.getLock().func_77946_l()));
                tileDoor.setLock(ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            state = (BlockState)state.func_177231_a((IProperty)DoorBlock.field_176519_b);
            worldIn.func_180501_a(pos, (BlockState)worldIn.func_180495_p(pos).func_177231_a((IProperty)DoorBlock.field_176519_b), 11);
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)worldIn.func_180495_p(pos.func_177984_a()).func_177231_a((IProperty)DoorBlock.field_176519_b), 11);
            worldIn.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b) != false ? BlockLockableDoor.getOpenSound() : BlockLockableDoor.getCloseSound(), pos, 0);
        }
        return ActionResultType.PASS;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_222013_iM);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b((IProperty)DoorBlock.field_176523_O);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b((IProperty)DoorBlock.field_176523_O) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            ItemStack itemstack = player.func_184614_ca();
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                Block.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
                Block.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (TileEntity)null, (Entity)player, (ItemStack)itemstack);
            }
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)DoorBlock.field_176519_b);
            }
        }
        return false;
    }

    public static int getCloseSound() {
        return 1011;
    }

    public static int getOpenSound() {
        return 1005;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{DoorBlock.field_176523_O, DoorBlock.field_176520_a, DoorBlock.field_176519_b, DoorBlock.field_176521_M});
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityLockableDoor door;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockableDoor && (door = (TileEntityLockableDoor)tileEntity).isLocked()) {
            int resist = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.PERSISTANCE.get()), (ItemStack)door.getLock()) + 1;
            return super.getExplosionResistance(state, world, pos, exploder, explosion) * (float)resist * 2.0f;
        }
        return super.getExplosionResistance(state, world, pos, exploder, explosion);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockableDoor) {
            TileEntityLockableDoor chest = (TileEntityLockableDoor)tileEntity;
            return chest.isPowered() && (Boolean)blockState.func_177229_b((IProperty)DoorBlock.field_176519_b) != false ? 15 : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityLockableDoor();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

