/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLocker;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockLocker
extends BlockConnectableContainer
implements IWaterLoggable {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BlockLocker() {
        this(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
    }

    public BlockLocker(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, HINGE, WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityLocker();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        ConnectedType connectedType = ConnectedType.SINGLE;
        Direction direction = context.func_195992_f().func_176734_d();
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean sneaking = context.func_225518_g_();
        DoorHingeSide hingeSide = this.getHingeSide(context);
        if (connectedType == ConnectedType.SINGLE && !sneaking) {
            if (direction == this.getDirectionToAttach(context, Direction.DOWN)) {
                connectedType = ConnectedType.SLAVE;
                hingeSide = (DoorHingeSide)context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(Direction.DOWN)).func_177229_b(HINGE);
            } else if (direction == this.getDirectionToAttach(context, Direction.UP)) {
                connectedType = ConnectedType.MASTER;
                hingeSide = (DoorHingeSide)context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(Direction.UP)).func_177229_b(HINGE);
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a(HINGE, (Comparable)hingeSide)).func_206870_a((IProperty)TYPE, (Comparable)((Object)connectedType))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facingState.func_177230_c() == this && facing.func_176740_k().func_200128_b()) {
            ConnectedType lockerType = (ConnectedType)((Object)facingState.func_177229_b((IProperty)TYPE));
            if (stateIn.func_177229_b((IProperty)TYPE) == ConnectedType.SINGLE && lockerType != ConnectedType.SINGLE && stateIn.func_177229_b((IProperty)FACING) == facingState.func_177229_b((IProperty)FACING) && BlockLocker.getDirectionToAttached(facingState) == facing.func_176734_d()) {
                return (BlockState)stateIn.func_206870_a((IProperty)TYPE, (Comparable)((Object)lockerType.opposite()));
            }
        } else if (BlockLocker.getDirectionToAttached(stateIn) == facing) {
            return (BlockState)stateIn.func_206870_a((IProperty)TYPE, (Comparable)((Object)ConnectedType.SINGLE));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext context) {
        BlockPos blockPos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        int offX = direction.func_82601_c();
        int offY = direction.func_82599_e();
        Vec3d v = context.func_221532_j();
        double hitX = v.field_72450_a - (double)blockPos.func_177958_n();
        double hitY = v.field_72449_c - (double)blockPos.func_177952_p();
        return !(offX < 0 && hitY < 0.5 || offX > 0 && hitY > 0.5 || offY < 0 && hitX > 0.5 || offY > 0 && hitX < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    @Nullable
    private Direction getDirectionToAttach(BlockItemUseContext context, Direction facing) {
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
        BlockState faceState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(facing));
        return faceState.func_177230_c() == this && faceState.func_177229_b((IProperty)TYPE) == ConnectedType.SINGLE ? (Direction)faceState.func_177229_b((IProperty)FACING) : null;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        return state.func_177229_b((IProperty)TYPE) == ConnectedType.SLAVE ? Direction.DOWN : Direction.UP;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityContainer) {
            ((TileEntityContainer)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityContainer) {
                ((TileEntityContainer)tileentity).dropInventoryItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return BlockLocker.calcRedstoneFromInventory((LazyOptional<IItemHandler>)((TileEntityLocker)worldIn.func_175625_s(pos)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
    }

    public static int calcRedstoneFromInventory(@Nullable LazyOptional<IItemHandler> lazyOptional) {
        if (!lazyOptional.isPresent()) {
            return 0;
        }
        IItemHandler inventory = (IItemHandler)lazyOptional.orElseGet(null);
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hit.func_216354_b() == state.func_177229_b((IProperty)FACING)) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            INamedContainerProvider locker = this.func_220052_b(state, worldIn, pos);
            if (locker != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)locker, (BlockPos)pos);
                player.func_71029_a(this.getOpenStat());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return this.getContainer(state, worldIn, pos, false);
    }

    public INamedContainerProvider getContainer(BlockState state, World worldIn, BlockPos pos, boolean allowBlockedChest) {
        ConnectedType chesttype1;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityLocker)) {
            return null;
        }
        if (!allowBlockedChest && BlockLocker.isBlocked((IWorld)worldIn, pos)) {
            return null;
        }
        TileEntityLocker locker = (TileEntityLocker)tileentity;
        ConnectedType chesttype = (ConnectedType)((Object)state.func_177229_b((IProperty)TYPE));
        if (chesttype == ConnectedType.SINGLE) {
            return locker;
        }
        BlockPos blockpos = pos.func_177972_a(BlockLocker.getDirectionToAttached(state));
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && (chesttype1 = (ConnectedType)((Object)iblockstate.func_177229_b((IProperty)TYPE))) != ConnectedType.SINGLE && chesttype != chesttype1 && iblockstate.func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING) && !allowBlockedChest && BlockLocker.isBlocked((IWorld)worldIn, blockpos)) {
            return null;
        }
        return locker;
    }

    private static boolean isBlocked(IWorld world, BlockPos pos) {
        return BlockLocker.isBehindSolidBlock((IBlockReader)world, pos);
    }

    private static boolean isBehindSolidBlock(IBlockReader reader, BlockPos worldIn) {
        Direction facing = (Direction)reader.func_180495_p(worldIn).func_177229_b((IProperty)FACING);
        BlockPos blockpos = worldIn.func_177972_a(facing);
        return reader.func_180495_p(blockpos).func_215686_e(reader, blockpos);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

