/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.fluid;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.fluid.BetterStorageFluids;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.util.BetterStorageResource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class FluidMilk
extends ForgeFlowingFluid {
    public static BetterStorageResource stillTexture = new BetterStorageResource("block/milk_still");
    public static BetterStorageResource flowingTexture = new BetterStorageResource("block/milk_flowing");
    public static Material MATERIAL_MILK = new Material.Builder(DyeColor.WHITE.func_196055_e()).func_200508_c().func_200507_a().func_200502_b().func_200509_f().func_200506_i();
    public static FluidAttributes.Builder BUILDER = FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture).color(-1).density(1025).temperature(310).viscosity(2000);
    public static ForgeFlowingFluid.Properties PROPERTIES = new ForgeFlowingFluid.Properties(BetterStorageFluids.MILK, BetterStorageFluids.FLOWING_MILK, BUILDER).bucket(() -> Items.field_151117_aB).block(BetterStorageBlocks.MILK);

    protected FluidMilk(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public static boolean interactFluidHandler(@Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull IFluidHandler handler) {
        ItemStack heldItem = new ItemStack((IItemProvider)BetterStorageItems.MILK_BUCKET.get());
        return (Boolean)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(playerInventory -> {
            FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
            }
            if (fluidActionResult.isSuccess()) {
                return true;
            }
            return false;
        }).orElse((Object)false);
    }

    public static boolean tryPlaceContainedLiquid(Item bucketitem, @Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult rayTraceResult) {
        if (bucketitem != Items.field_151117_aB) {
            return false;
        }
        Fluid containedBlock = (Fluid)BetterStorageFluids.MILK.get();
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_(containedBlock);
        if (blockstate.func_196958_f() || flag || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, containedBlock)) {
            if (worldIn.field_73011_w.func_177500_n() && containedBlock == BetterStorageFluids.MILK.get()) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && containedBlock == BetterStorageFluids.MILK.get()) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)containedBlock).func_207204_a(false))) {
                    worldIn.func_184133_a(player, posIn, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180501_a(posIn, containedBlock.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return rayTraceResult == null ? false : FluidMilk.tryPlaceContainedLiquid(bucketitem, player, worldIn, rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b()), null);
    }
}

