/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.inventory.ExpandableStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ConnectedStackHandler
extends ExpandableStackHandler {
    private final ItemStackHandler inventoryUpper;
    private final ItemStackHandler inventoryLower;

    public ConnectedStackHandler(ExpandableStackHandler inventoryUpper, ExpandableStackHandler inventoryLower) {
        super(Math.max(inventoryUpper.getColumns(), inventoryLower.getColumns()), inventoryUpper.getRows() + inventoryLower.getRows());
        this.inventoryUpper = inventoryUpper;
        this.inventoryLower = inventoryLower;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int divide = this.inventoryUpper.getSlots();
        if (slot < divide) {
            this.inventoryUpper.setStackInSlot(slot, stack);
        } else {
            this.inventoryLower.setStackInSlot(slot - divide, stack);
        }
    }

    public int getSlots() {
        return this.inventoryUpper.getSlots() + this.inventoryLower.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        int divide = this.inventoryUpper.getSlots();
        if (slot < divide) {
            return this.inventoryUpper.getStackInSlot(slot);
        }
        return this.inventoryLower.getStackInSlot(slot - divide);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int divide = this.inventoryUpper.getSlots();
        if (slot < divide) {
            return this.inventoryUpper.insertItem(slot, stack, simulate);
        }
        return this.inventoryLower.insertItem(slot - divide, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int divide = this.inventoryUpper.getSlots();
        if (slot < divide) {
            return this.inventoryUpper.extractItem(slot, amount, simulate);
        }
        return this.inventoryLower.extractItem(slot - divide, amount, simulate);
    }
}

