/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import com.google.common.base.MoreObjects;
import io.github.tehstoneman.betterstorage.common.inventory.Region;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import io.github.tehstoneman.betterstorage.common.world.CrateStackCollection;
import io.github.tehstoneman.betterstorage.util.BlockUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class CrateStackHandler
extends ItemStackHandler {
    private static final int maxCratePileSize = 125;
    private Region region;
    private UUID pileID;
    private List<Integer> indexSlots;
    private final List<BlockPos> listCrates = new ArrayList<BlockPos>();
    private boolean doShuffle = true;
    private TileEntityCrate crateToUpdate;

    public CrateStackHandler(int size) {
        super(size);
        this.indexSlots = this.getShuffledIndexes(size);
    }

    public UUID getPileID() {
        return this.pileID;
    }

    public void setPileID(UUID pileID) {
        this.pileID = pileID;
    }

    public int getNumCrates() {
        return this.listCrates == null ? 0 : this.listCrates.size();
    }

    public int getCapacity() {
        return CrateStackHandler.getCapacity(this.getNumCrates());
    }

    public static int getCapacity(int numCrates) {
        return numCrates * (18 + Math.min(numCrates / 6, 18));
    }

    public Region getRegion() {
        if (this.region == null) {
            this.region = Region.EMPTY.clone();
        }
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setSize(int size) {
        this.stacks = this.copyStack((NonNullList<ItemStack>)this.stacks, size);
        this.indexSlots = this.getShuffledIndexes(size);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(this.getIndexedSlot(slot), stack);
    }

    public void setStackInSlotFixed(int slot, ItemStack stack) {
        this.doShuffle = false;
        super.setStackInSlot(slot, stack);
        this.doShuffle = true;
    }

    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(this.getIndexedSlot(slot));
    }

    public ItemStack getStackInSlotFixed(int slot) {
        return super.getStackInSlot(slot);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(this.getIndexedSlot(slot), amount, simulate);
    }

    public ItemStack extractItemFixed(int slot, int amount, boolean simulate) {
        this.doShuffle = false;
        ItemStack result = super.extractItem(slot, amount, simulate);
        this.doShuffle = true;
        return result;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(this.getIndexedSlot(slot), stack, simulate);
    }

    public ItemStack insertItemFixed(int slot, ItemStack stack, boolean simulate) {
        this.doShuffle = false;
        ItemStack result = super.insertItem(slot, stack, simulate);
        this.doShuffle = true;
        return result;
    }

    public int getIndexedSlot(int slot) {
        if (slot < 0) {
            slot = 0;
        }
        if (slot >= this.indexSlots.size()) {
            slot = this.indexSlots.size() - 1;
        }
        return this.indexSlots.get(slot);
    }

    public int getOccupiedSlots() {
        int count = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public List<Integer> getShuffledIndexes(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int occupied = this.getOccupiedSlots();
        for (int i = 0; i < Math.max(count, occupied); ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        return list.subList(0, count);
    }

    public void consolidateStacks() {
        for (int i = 1; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b() || this.mergeItemStack((ItemStack)this.stacks.get(i), 0, i) != 0) continue;
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int mergeItemStack(ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_77985_e()) {
            for (int i = startIndex; stack.func_190916_E() > 0 && i < endIndex; ++i) {
                ItemStack itemstack = (ItemStack)this.stacks.get(i);
                if (itemstack.func_190926_b()) {
                    this.stacks.set(i, (Object)stack.func_77946_l());
                    stack.func_190920_e(0);
                    break;
                }
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemstack)) continue;
                int newSize = itemstack.func_190916_E() + stack.func_190916_E();
                if (newSize <= stack.func_77976_d()) {
                    stack.func_190920_e(0);
                    itemstack.func_190920_e(newSize);
                    continue;
                }
                if (itemstack.func_190916_E() >= stack.func_77976_d()) continue;
                int count = stack.func_77976_d() - itemstack.func_190916_E();
                stack.func_190920_e(stack.func_190916_E() - count);
                itemstack.func_190920_e(stack.func_77976_d());
            }
        }
        return stack.func_190916_E();
    }

    public boolean canAdd(TileEntityCrate crate) {
        return this.getNumCrates() < 125 && (this.region.contains(crate.func_174877_v()) || this.canExpand(crate));
    }

    private boolean canExpand(TileEntityCrate crate) {
        int volume = this.region.volume();
        if (this.getNumCrates() < volume) {
            return false;
        }
        int width = this.region.width();
        int height = this.region.height();
        int depth = this.region.depth();
        if (crate.func_174877_v().func_177958_n() < this.region.posMin.func_177958_n() || crate.func_174877_v().func_177958_n() > this.region.posMax.func_177958_n()) {
            int maxDiff;
            if (width >= 125) {
                return false;
            }
            int n = maxDiff = height == 1 ? 1 : 3;
            if (width >= maxDiff + Math.min(height, depth)) {
                return false;
            }
        } else if (crate.func_174877_v().func_177952_p() < this.region.posMin.func_177952_p() || crate.func_174877_v().func_177952_p() > this.region.posMax.func_177952_p()) {
            int maxDiff;
            if (depth >= 125) {
                return false;
            }
            int n = maxDiff = width == 1 ? 1 : 3;
            if (depth >= maxDiff + Math.min(height, depth)) {
                return false;
            }
        } else if (crate.func_174877_v().func_177956_o() < this.region.posMin.func_177956_o() || crate.func_174877_v().func_177956_o() > this.region.posMax.func_177956_o()) {
            int maxDiff;
            if (height >= 125) {
                return false;
            }
            int n = maxDiff = width == 1 || depth == 1 ? 1 : 4;
            if (height >= maxDiff + Math.min(width, depth)) {
                return false;
            }
        }
        return true;
    }

    public void addCrate(TileEntityCrate crate) {
        if (this.getNumCrates() == 0 || this.region == null) {
            this.region = new Region(crate);
        } else {
            this.region.expandToContain(crate);
        }
        this.listCrates.add(crate.func_174877_v());
        this.stacks = this.copyStack((NonNullList<ItemStack>)this.stacks, this.getCapacity());
        if (crate.hasID() && !crate.getPileID().equals(this.getPileID())) {
            NonNullList<ItemStack> overflow = crate.getCrateStackHandler().removeCrate(crate);
            this.mergeStack(overflow);
        }
        crate.setPileID(this.getPileID());
        crate.func_70296_d();
    }

    public NonNullList<ItemStack> removeCrate(TileEntityCrate crate) {
        if (this.listCrates != null && this.listCrates.contains(crate.func_174877_v())) {
            int i = this.listCrates.indexOf(crate.func_174877_v());
            this.listCrates.remove(i);
            CrateStackCollection collection = CrateStackCollection.getCollection(crate.func_145831_w());
            collection.func_76185_a();
            if (this.getNumCrates() > 0) {
                NonNullList<ItemStack> overflow = this.copyStack((NonNullList<ItemStack>)this.stacks, this.getCapacity(), this.stacks.size());
                this.setSize(this.getCapacity());
                return overflow;
            }
            collection.removeCratePile(this.pileID);
            return this.stacks;
        }
        return NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public ItemStack[] getRandomStacks(int count) {
        List items = this.stacks.subList(0, this.stacks.size());
        Collections.shuffle(items);
        return (ItemStack[])Arrays.copyOf(items.toArray(), count);
    }

    public void removeItems(ItemStack itemStack) {
        int i;
        for (i = 0; i < this.stacks.size() && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(i)), (ItemStack)itemStack); ++i) {
        }
        if (i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b()) {
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void addItems(ItemStack stack) {
        int i;
        int count = stack.func_190916_E();
        for (i = 0; i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b(); ++i) {
        }
        if (i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b()) {
            this.stacks.set(i, (Object)stack.func_77946_l());
        }
    }

    public void trimRegion(World world) {
        Region region = Region.EMPTY.clone();
        for (BlockPos pos : BlockUtils.getAllInBox(this.region.posMin, this.region.posMax)) {
            TileEntityCrate tileCrate = TileEntityCrate.getCrateAt((IBlockReader)world, pos);
            if (tileCrate == null || !tileCrate.getPileID().equals(this.pileID)) continue;
            region.expandToContain(pos);
        }
        if (!region.isEmpty()) {
            this.region = region;
        }
    }

    public NonNullList<ItemStack> copyStack(NonNullList<ItemStack> stackIn, int size) {
        return this.copyStack(stackIn, 0, size);
    }

    public NonNullList<ItemStack> copyStack(NonNullList<ItemStack> stackIn, int from, int to) {
        int size = to - from;
        NonNullList stackOut = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(size, stackIn.size()); ++i) {
            stackOut.set(i, stackIn.get(i + from));
        }
        return stackOut;
    }

    public void mergeStack(NonNullList<ItemStack> stackIn) {
        for (ItemStack itemStack : stackIn) {
            if (itemStack.func_190926_b() || this.mergeItemStack(itemStack, 0, this.stacks.size()) == 0) continue;
            this.addItems(itemStack);
        }
    }

    public void sendUpdatesTo(TileEntityCrate tileEntityCrate) {
        this.crateToUpdate = tileEntityCrate;
    }

    protected void onContentsChanged(int slot) {
        if (this.doShuffle) {
            this.consolidateStacks();
            this.indexSlots = this.getShuffledIndexes(this.stacks.size());
        }
        if (this.crateToUpdate != null) {
            this.crateToUpdate.func_70296_d();
        }
    }

    protected void onLoad() {
        this.indexSlots = this.getShuffledIndexes(this.stacks.size());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        if (this.getNumCrates() > 0) {
            ListNBT list = new ListNBT();
            for (BlockPos pos : this.listCrates) {
                list.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            nbt.func_218657_a("Crates", (INBT)list);
        }
        if (this.pileID != null) {
            nbt.func_186854_a("PileID", this.pileID);
        }
        if (this.region != null) {
            nbt.func_218657_a("Region", (INBT)this.region.toCompound());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b("Crates")) {
            ListNBT list = nbt.func_150295_c("Crates", 10);
            this.listCrates.clear();
            for (INBT tag : list) {
                this.listCrates.add(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)tag)));
            }
        }
        if (nbt.func_186855_b("PileID")) {
            this.pileID = nbt.func_186857_a("PileID");
        }
        if (nbt.func_74764_b("Region")) {
            this.region = Region.fromCompound(nbt.func_74775_l("Region"));
        }
        this.onLoad();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("pileID", (Object)this.pileID).add("numCrates", this.getNumCrates()).toString();
    }
}

