/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class ExpandableStackHandler
extends ItemStackHandler {
    private int columns;
    private int rows;

    public ExpandableStackHandler(int columns, int rows) {
        super(columns * rows);
        this.columns = columns;
        this.rows = rows;
    }

    public ExpandableStackHandler(ExpandableStackHandler inventory) {
        super(inventory.stacks);
        this.columns = inventory.getColumns();
        this.rows = inventory.getRows();
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setSize(int size) {
        this.stacks = this.copyStacks((NonNullList<ItemStack>)this.stacks, size);
        this.rows = size / 9;
        this.columns = 9;
    }

    public NonNullList<ItemStack> copyStacks(NonNullList<ItemStack> stackIn, int size) {
        return this.copyStacks(stackIn, 0, size);
    }

    public NonNullList<ItemStack> copyStacks(NonNullList<ItemStack> stackIn, int from, int to) {
        int size = to - from;
        NonNullList stackOut = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(size, stackIn.size()); ++i) {
            stackOut.set(i, stackIn.get(i + from));
        }
        return stackOut;
    }

    public NonNullList<ItemStack> copyStacks(int from, int to) {
        int size = to - from;
        return this.copyStacks((NonNullList<ItemStack>)this.stacks, from, size);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("Columns", this.columns);
        nbt.func_74768_a("Rows", this.rows);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.columns = nbt.func_74764_b("Columns") ? (this.columns = nbt.func_74762_e("Columns")) : 9;
        this.rows = nbt.func_74764_b("Rows") ? nbt.func_74762_e("Rows") : this.stacks.size() / 9;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.stacks) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

