/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.inventory.KeyringStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeyringCapabilityProvider
implements ICapabilitySerializable<CompoundNBT> {
    private final ItemStack invItem;
    public KeyringStackHandler inventory;
    private final LazyOptional<IItemHandler> inventoryHandler = LazyOptional.of(() -> this.inventory);

    public KeyringCapabilityProvider(ItemStack stack) {
        this.invItem = stack;
        int size = this.getSizeContents();
        this.inventory = size > 0 ? new KeyringStackHandler(size){

            protected void onContentsChanged(int slot) {
                KeyringCapabilityProvider.this.markDirty();
            }
        } : null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.inventoryHandler);
        }
        return LazyOptional.empty();
    }

    protected int getSizeContents() {
        return 9;
    }

    public void markDirty() {
        CompoundNBT tag = this.invItem.func_196082_o();
        int count = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        tag.func_74768_a("Occupied", count);
    }

    public CompoundNBT serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.deserializeNBT(nbt);
    }
}

