/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import com.google.common.base.MoreObjects;
import io.github.tehstoneman.betterstorage.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Region {
    public BlockPos posMin;
    public BlockPos posMax;
    public static final Region EMPTY = new Region(BlockPos.field_177992_a);

    public Region(BlockPos posMin, BlockPos posMax) {
        this.posMin = posMin;
        this.posMax = posMax;
    }

    public Region(BlockPos pos) {
        this(pos, pos);
    }

    public Region(TileEntity entity) {
        this(entity.func_174877_v());
    }

    public int width() {
        return this.isEmpty() ? 0 : this.posMax.func_177958_n() - this.posMin.func_177958_n() + 1;
    }

    public int depth() {
        return this.isEmpty() ? 0 : this.posMax.func_177952_p() - this.posMin.func_177952_p() + 1;
    }

    public int height() {
        return this.isEmpty() ? 0 : this.posMax.func_177956_o() - this.posMin.func_177956_o() + 1;
    }

    public int volume() {
        return this.width() * this.depth() * this.height();
    }

    public void set(BlockPos posMin, BlockPos posMax) {
        this.posMin = new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p()));
        this.posMax = new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p()));
    }

    public void expand(BlockPos posMin, BlockPos posMax) {
        if (this.equals(EMPTY)) {
            this.set(posMin, posMax);
        }
        this.posMin.func_177973_b((Vec3i)new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p())));
        this.posMax.func_177971_a((Vec3i)new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p())));
    }

    public void expand(int size) {
        this.expand(new BlockPos(size, size, size), new BlockPos(size, size, size));
    }

    public void expandToContain(BlockPos pos) {
        if (this.equals(EMPTY)) {
            this.set(pos, pos);
        }
        this.posMin = new BlockPos(Math.min(this.posMin.func_177958_n(), pos.func_177958_n()), Math.min(this.posMin.func_177956_o(), pos.func_177956_o()), Math.min(this.posMin.func_177952_p(), pos.func_177952_p()));
        this.posMax = new BlockPos(Math.max(this.posMax.func_177958_n(), pos.func_177958_n()), Math.max(this.posMax.func_177956_o(), pos.func_177956_o()), Math.max(this.posMax.func_177952_p(), pos.func_177952_p()));
    }

    public void expandToContain(TileEntity entity) {
        this.expandToContain(entity.func_174877_v());
    }

    public void expandToContain(Region region) {
        if (this.equals(EMPTY)) {
            this.set(region.posMin, region.posMax);
        } else {
            this.posMin = new BlockPos(Math.min(this.posMin.func_177958_n(), region.posMin.func_177958_n()), Math.min(this.posMin.func_177956_o(), region.posMin.func_177956_o()), Math.min(this.posMin.func_177952_p(), region.posMin.func_177952_p()));
            this.posMax = new BlockPos(Math.max(this.posMax.func_177958_n(), region.posMax.func_177958_n()), Math.max(this.posMax.func_177956_o(), region.posMax.func_177956_o()), Math.max(this.posMax.func_177952_p(), region.posMax.func_177952_p()));
        }
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean isFull(World world, Block block) {
        for (BlockPos blockPos : BlockUtils.getAllInBox(this.posMin, this.posMax)) {
            if (world.func_180495_p(blockPos).func_177230_c().equals(block)) continue;
            return false;
        }
        return true;
    }

    public boolean isFull(World world, TileEntity tileEntity) {
        for (BlockPos blockPos : BlockUtils.getAllInBox(this.posMin, this.posMax)) {
            if (world.func_175625_s(blockPos).equals(tileEntity)) continue;
            return false;
        }
        return true;
    }

    public void contract(BlockPos posMin, BlockPos posMax) {
        this.posMin.func_177971_a((Vec3i)new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p())));
        this.posMax.func_177973_b((Vec3i)new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p())));
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.posMin.func_177958_n() && pos.func_177956_o() >= this.posMin.func_177956_o() && pos.func_177952_p() >= this.posMin.func_177952_p() && pos.func_177958_n() <= this.posMax.func_177958_n() && pos.func_177956_o() <= this.posMax.func_177956_o() && pos.func_177952_p() <= this.posMax.func_177952_p();
    }

    public boolean contains(TileEntity entity) {
        return this.contains(entity.func_174877_v());
    }

    public CompoundNBT toCompound() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("posMin", (INBT)NBTUtil.func_186859_a((BlockPos)this.posMin));
        nbt.func_218657_a("posMax", (INBT)NBTUtil.func_186859_a((BlockPos)this.posMax));
        return nbt;
    }

    public static Region fromCompound(CompoundNBT nbt) {
        BlockPos posMin = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("posMin"));
        BlockPos posMax = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("posMax"));
        return new Region(posMin, posMax);
    }

    public Region clone() {
        return new Region(this.posMin, this.posMax);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.posMin.toString()).add("max", (Object)this.posMax.toString()).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Region) {
            Region test = (Region)obj;
            return test.posMin.equals((Object)this.posMin) && test.posMax.equals((Object)this.posMax);
        }
        return false;
    }
}

