/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item;

import io.github.tehstoneman.betterstorage.common.item.ItemBetterStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public class ItemBucketSlime
extends ItemBetterStorage {
    private static Map<ResourceLocation, Handler> handlers = new HashMap<ResourceLocation, Handler>();

    public ItemBucketSlime() {
        super(new Item.Properties());
    }

    public static void registerHandler(Handler handler) {
        handlers.put(handler.resourceLocation, handler);
    }

    public static Handler getHandler(ResourceLocation resourceLocation) {
        return handlers.get(resourceLocation);
    }

    public static enum EnumSlime implements IStringSerializable
    {
        GREEN_SLIME(0, "Slime", new ResourceLocation("slime")),
        MAGMA_CUBE(1, "LavaSlime", new ResourceLocation("magma_cube"));

        private final int meta;
        private final String name;
        private final ResourceLocation resourceLocation;
        private static EnumSlime[] META_LOOKUP;
        private static Map<String, EnumSlime> NAME_LOOKUP;

        private EnumSlime(int meta, String name, ResourceLocation resourceLocation) {
            this.meta = meta;
            this.name = name;
            this.resourceLocation = resourceLocation;
        }

        public static EnumSlime byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static EnumSlime byName(String name) {
            return NAME_LOOKUP.get(name);
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumSlime[EnumSlime.values().length];
            NAME_LOOKUP = new HashMap<String, EnumSlime>();
            EnumSlime[] enumSlimeArray = EnumSlime.values();
            int n = enumSlimeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumSlime slime;
                EnumSlime.META_LOOKUP[slime.getMetadata()] = slime = enumSlimeArray[i];
                NAME_LOOKUP.put(slime.name, slime);
            }
        }
    }

    public static class Handler {
        public final String name;
        public final ResourceLocation resourceLocation;

        public Handler(String name, String entityName) {
            this.name = name;
            this.resourceLocation = null;
        }

        public Handler(String name, ResourceLocation resource) {
            this.name = name;
            this.resourceLocation = resource;
        }

        public int foodAmount() {
            return 4;
        }

        public float saturationAmount() {
            return 0.3f;
        }

        public float durationMultiplier() {
            return 0.25f;
        }
    }
}

