/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.KeyLockItem;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentKey;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemKey
extends KeyLockItem
implements IKey {
    public ItemKey() {
        super(new Item.Properties().func_200916_a(BetterStorage.ITEM_GROUP));
    }

    @Override
    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        if (!worldIn.field_72995_K) {
            this.ensureHasID(stack);
        }
    }

    @Override
    public int func_77619_b() {
        return 20;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        Hand hand = context.func_221531_n();
        if (!worldIn.field_72995_K && hand == Hand.MAIN_HAND) {
            BlockState state;
            PlayerEntity playerIn = context.func_195999_j();
            ItemStack stack = playerIn.func_184586_b(hand);
            BlockPos pos = context.func_195995_a();
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity == null && (state = worldIn.func_180495_p(pos)).func_206869_a().contains(DoorBlock.field_176523_O) && state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
                pos = pos.func_177977_b();
                tileEntity = worldIn.func_175625_s(pos);
            }
            if (tileEntity instanceof IKeyLockable) {
                IKeyLockable lockable = (IKeyLockable)tileEntity;
                if (this.unlock(stack, lockable.getLock(), false)) {
                    if (playerIn.func_213453_ef()) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), lockable.getLock().func_77946_l()));
                        lockable.setLock(ItemStack.field_190927_a);
                    }
                    return ActionResultType.SUCCESS;
                }
                ((ILock)lockable.getLock().func_77973_b()).applyEffects(lockable.getLock(), lockable, playerIn, LockInteraction.PICK);
            }
        }
        return super.func_195939_a(context);
    }

    @Override
    public boolean unlock(ItemStack key, ItemStack lock, boolean useAbility) {
        int roll;
        UUID keyId;
        ILock lockType = (ILock)lock.func_77973_b();
        if (lockType.getLockType() != "normal") {
            return false;
        }
        UUID lockId = this.getID(lock);
        if (lockId.equals(keyId = this.getID(key))) {
            return true;
        }
        int lockSecurity = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.SECURITY.get()), (ItemStack)lock);
        int unlocking = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.UNLOCKING.get()), (ItemStack)key);
        int lockpicking = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.LOCKPICKING.get()), (ItemStack)key);
        int morphing = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.MORPHING.get()), (ItemStack)key);
        int effectiveUnlocking = Math.max(0, unlocking - lockSecurity);
        int effectiveLockpicking = Math.max(0, lockpicking - lockSecurity);
        int effectiveMorphing = Math.max(0, morphing - lockSecurity);
        if (effectiveUnlocking > 0 && effectiveUnlocking > (roll = BetterStorage.RANDOM.nextInt(5))) {
            return true;
        }
        if (effectiveLockpicking > 0) {
            EnchantmentBetterStorage.decEnchantment(key, (Enchantment)EnchantmentBetterStorage.LOCKPICKING.get(), 1);
            return true;
        }
        if (effectiveMorphing > 0) {
            this.setID(key, lockId);
            EnchantmentBetterStorage.decEnchantment(key, (Enchantment)EnchantmentBetterStorage.MORPHING.get(), morphing);
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return enchantment instanceof EnchantmentKey;
    }
}

