/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.KeyLockItem;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockLockableDoor;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentLock;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockableDoor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemLock
extends KeyLockItem
implements ILock {
    public ItemLock() {
        super(new Item.Properties().func_200916_a(BetterStorage.ITEM_GROUP));
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            this.ensureHasID(stack);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (hand == Hand.MAIN_HAND) {
            IKeyLockable lockable;
            TileEntity tileEntity;
            BlockState blockState = worldIn.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block == Blocks.field_150454_av) {
                if (blockState.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
                    pos = pos.func_177977_b();
                    blockState = worldIn.func_180495_p(pos);
                    block = blockState.func_177230_c();
                }
                worldIn.func_175656_a(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockLockableDoor)BetterStorageBlocks.LOCKABLE_DOOR.get()).func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, blockState.func_177229_b((IProperty)DoorBlock.field_176520_a))).func_206870_a((IProperty)DoorBlock.field_176519_b, blockState.func_177229_b((IProperty)DoorBlock.field_176519_b))).func_206870_a((IProperty)DoorBlock.field_176521_M, blockState.func_177229_b((IProperty)DoorBlock.field_176521_M))).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
                worldIn.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)((BlockState)((BlockLockableDoor)BetterStorageBlocks.LOCKABLE_DOOR.get()).func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, blockState.func_177229_b((IProperty)DoorBlock.field_176520_a))).func_206870_a((IProperty)DoorBlock.field_176519_b, blockState.func_177229_b((IProperty)DoorBlock.field_176519_b))).func_206870_a((IProperty)DoorBlock.field_176521_M, blockState.func_177229_b((IProperty)DoorBlock.field_176521_M))).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER));
                tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileEntityLockableDoor && (lockable = (TileEntityLockableDoor)tileEntity).isLockValid(stack)) {
                    ((TileEntityLockableDoor)lockable).setLock(stack.func_77946_l());
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if ((tileEntity = worldIn.func_175625_s(pos)) instanceof IKeyLockable && (lockable = (IKeyLockable)tileEntity).isLockValid(stack) && lockable.getLock().func_190926_b()) {
                lockable.setLock(stack.func_77946_l());
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }

    @Override
    public void onUnlock(ItemStack lock, ItemStack key, IKeyLockable lockable, PlayerEntity player, boolean success) {
        if (success) {
            return;
        }
        this.applyEffects(lock, lockable, player, key.func_190926_b() ? LockInteraction.OPEN : LockInteraction.PICK);
    }

    @Override
    public void applyEffects(ItemStack lock, IKeyLockable lockable, PlayerEntity player, LockInteraction interaction) {
        int shock = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.SHOCK.get()), (ItemStack)lock);
        if (shock > 0) {
            int damage = shock;
            if (interaction == LockInteraction.PICK) {
                damage *= 3;
            }
            player.func_70097_a(DamageSource.field_76376_m, (float)damage);
            World world = player.func_130014_f_();
            world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187606_E, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (shock >= 3 && interaction != LockInteraction.OPEN) {
                player.func_70015_d(3);
            }
        }
    }

    @Override
    public boolean canApplyEnchantment(ItemStack lock, Enchantment enchantment) {
        return enchantment instanceof EnchantmentLock;
    }
}

