/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.common.block.BlockContainerBetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.ExpandableStackHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityContainer
extends TileEntity
implements INamedContainerProvider,
INameable {
    public ExpandableStackHandler inventory;
    private final LazyOptional<IItemHandler> inventoryHandler = LazyOptional.of(() -> this.inventory);
    protected ITextComponent customName;
    protected int numPlayersUsing;
    public int ticksExisted = 0;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    protected static int EVENT_PLAYER_USING = 1;

    public TileEntityContainer(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        int size = this.getSizeContents();
        this.inventory = size > 0 ? new ExpandableStackHandler(this.getColumns(), this.getRows()){

            protected void onContentsChanged(int slot) {
                TileEntityContainer.this.func_70296_d();
            }
        } : null;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.inventoryHandler);
        }
        return super.getCapability(capability, facing);
    }

    private IItemHandler createHandler() {
        return new ExpandableStackHandler(this.getColumns(), this.getRows());
    }

    public int getColumns() {
        return 9;
    }

    public int getRows() {
        return 3;
    }

    protected int getSizeContents() {
        return this.getColumns() * this.getRows();
    }

    public final int getPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setCustomName(@Nullable ITextComponent name) {
        this.customName = name;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return this.func_200201_e();
        }
        return this.func_200200_C_();
    }

    public void markForUpdate() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    public void dropInventoryItems() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    public void openInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void closeInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockContainerBetterStorage) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, EVENT_PLAYER_USING, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == EVENT_PLAYER_USING) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.inventory.getSlots() > 0) {
            nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        }
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200201_e()));
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        super.handleUpdateTag(nbt);
        if (nbt.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT((CompoundNBT)nbt.func_74781_a("Inventory"));
        }
        if (nbt.func_74764_b("CustomName")) {
            this.setCustomName(ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomName")));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (this.inventory.getSlots() > 0) {
            nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        }
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200201_e()));
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT((CompoundNBT)nbt.func_74781_a("Inventory"));
        }
        if (nbt.func_74764_b("CustomName")) {
            this.setCustomName(ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomName")));
        }
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT((CompoundNBT)nbt.func_74781_a("inventory"));
        }
        super.func_145839_a(nbt);
    }
}

