/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.IHasConfig;
import io.github.tehstoneman.betterstorage.api.IHexKeyConfig;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.common.capabilities.CapabilityConfig;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.ConfigContainer;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerReinforcedLocker;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLocker;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import io.github.tehstoneman.betterstorage.common.world.storage.HexKeyConfig;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityReinforcedLocker
extends TileEntityLocker
implements IKeyLockable,
IHasConfig {
    private boolean powered;
    private ItemStack lock = ItemStack.field_190927_a.func_77946_l();
    public HexKeyConfig config;
    private final LazyOptional<IHexKeyConfig> configHandler = LazyOptional.of(() -> this.config);

    public TileEntityReinforcedLocker() {
        super((TileEntityType)BetterStorageTileEntityTypes.REINFORCED_LOCKER.get());
        this.config = new HexKeyConfig(){

            protected void onContentsChanged(int slot) {
                TileEntityReinforcedLocker.this.func_70296_d();
            }
        };
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.isLocked() && facing != null) {
            return LazyOptional.empty();
        }
        if (capability == CapabilityConfig.CONFIG_CAPABILITY && !this.isLocked()) {
            return CapabilityConfig.CONFIG_CAPABILITY.orEmpty(capability, this.configHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getColumns() {
        return (Integer)BetterStorageConfig.COMMON.reinforcedColumns.get();
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.reinforced_locker";
    }

    @Override
    public void dropInventoryItems() {
        super.dropInventoryItems();
        if (!this.config.isEmpty()) {
            if (this.isConnected() && this.isMain()) {
                ((TileEntityReinforcedLocker)this.getConnectedTileEntity()).setConfig(this.config);
            } else {
                for (int i = 0; i < this.config.getSlots(); ++i) {
                    ItemStack stack = this.config.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
                }
            }
        }
    }

    @Override
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        if (this.isMain()) {
            if (player.func_184614_ca().func_77973_b() == BetterStorageItems.HEX_KEY.get()) {
                return new ConfigContainer(windowID, playerInventory, this.field_145850_b, this.field_174879_c);
            }
            return new ContainerReinforcedLocker(windowID, playerInventory, this.field_145850_b, this.field_174879_c);
        }
        return this.getMainTileEntity().createMenu(windowID, playerInventory, player);
    }

    @Override
    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (PlayerEntity entityplayer : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(entityplayer.field_71070_bA instanceof ContainerReinforcedLocker)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    public ItemStack getLock() {
        if (this.isMain()) {
            return this.lock;
        }
        return ((IKeyLockable)((Object)this.getMainTileEntity())).getLock();
    }

    @Override
    public void setLock(ItemStack lock) {
        if (this.isMain()) {
            if (lock.func_190926_b() || this.isLockValid(lock)) {
                this.lock = lock;
                this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                this.setPowered(EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.TRIGGER.get()), (ItemStack)lock) > 0);
                this.func_70296_d();
            }
        } else {
            ((IKeyLockable)((Object)this.getMainTileEntity())).setLock(lock);
        }
    }

    @Override
    public boolean canUse(PlayerEntity player) {
        return !this.isLocked() || this.getMainTileEntity().getPlayersUsing() > 0;
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    @Override
    public boolean unlockWith(ItemStack heldItem) {
        Item item = heldItem.func_77973_b();
        return item instanceof IKey ? ((IKey)item).unlock(heldItem, this.getLock(), false) : false;
    }

    public boolean isPowered() {
        if (this.isMain()) {
            return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)EnchantmentBetterStorage.TRIGGER.get()), (ItemStack)this.getLock()) > 0;
        }
        return ((TileEntityReinforcedChest)this.getMainTileEntity()).isPowered();
    }

    public void setPowered(boolean powered) {
        if (!this.isMain()) {
            ((TileEntityReinforcedLocker)this.getMainTileEntity()).setPowered(powered);
            return;
        }
        this.powered = powered;
        Block block = this.func_195044_w().func_177230_c();
        this.func_145831_w().func_195593_d(this.field_174879_c, block);
        if (this.isConnected()) {
            this.func_145831_w().func_195593_d(this.getConnected(), block);
        }
    }

    @Override
    public HexKeyConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(HexKeyConfig config) {
        this.config = config;
        this.func_70296_d();
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (!this.config.isEmpty()) {
            nbt.func_218657_a("Config", (INBT)this.config.serializeNBT());
        }
        if (!this.lock.func_190926_b()) {
            nbt.func_218657_a("lock", (INBT)this.lock.serializeNBT());
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        } else {
            this.config = new HexKeyConfig();
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void handleUpdateTag(CompoundNBT nbt) {
        super.handleUpdateTag(nbt);
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        } else {
            this.config = new HexKeyConfig();
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (!this.config.isEmpty()) {
            nbt.func_218657_a("Config", (INBT)this.config.serializeNBT());
        }
        if (!this.lock.func_190926_b()) {
            CompoundNBT lockNBT = new CompoundNBT();
            this.lock.func_77955_b(lockNBT);
            nbt.func_218657_a("lock", (INBT)lockNBT);
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("Config")) {
            this.config.deserializeNBT(nbt.func_74775_l("Config"));
        } else {
            this.config = new HexKeyConfig();
        }
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
        super.func_145839_a(nbt);
    }
}

