/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.world;

import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class CrateStackCollection
extends WorldSavedData {
    private static final String filename = "betterstorage_cratepile";
    private final Map<UUID, CrateStackHandler> pileDataMap = new HashMap<UUID, CrateStackHandler>();

    public CrateStackCollection() {
        this(filename);
    }

    public CrateStackCollection(String filename) {
        super(filename);
    }

    @Nullable
    public static CrateStackCollection getCollection(World world) {
        if (world.field_72995_K) {
            return null;
        }
        DimensionType dimType = world.func_201675_m().func_186058_p();
        DimensionSavedDataManager manager = world.func_73046_m().func_71218_a(dimType).func_217481_x();
        WorldSavedData data = manager.func_215752_a(CrateStackCollection::new, filename);
        return (CrateStackCollection)data;
    }

    public CrateStackHandler getOrCreateCratePile(@Nullable UUID pileID) {
        if (pileID == null) {
            while (this.pileDataMap.containsKey(pileID = UUID.randomUUID())) {
            }
        }
        if (!this.pileDataMap.containsKey(pileID)) {
            CrateStackHandler cratePile = new CrateStackHandler(18);
            this.pileDataMap.put(pileID, cratePile);
            return this.addCrateToPile(pileID);
        }
        return this.pileDataMap.get(pileID);
    }

    public CrateStackHandler createCratePile() {
        UUID pileID = UUID.randomUUID();
        while (this.pileDataMap.containsKey(pileID)) {
            pileID = UUID.randomUUID();
        }
        return this.addCrateToPile(pileID);
    }

    public CrateStackHandler addCrateToPile(UUID pileID) {
        CrateStackHandler cratePile = new CrateStackHandler(18);
        cratePile.setPileID(pileID);
        this.pileDataMap.put(pileID, cratePile);
        this.func_76185_a();
        return cratePile;
    }

    public void removeCratePile(UUID pileID) {
        this.pileDataMap.remove(pileID);
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (!nbt.isEmpty()) {
            for (String key : nbt.func_150296_c()) {
                CrateStackHandler crateStackHandler = new CrateStackHandler(0);
                crateStackHandler.deserializeNBT(nbt.func_74775_l(key));
                this.pileDataMap.put(UUID.fromString(key), crateStackHandler);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        if (!this.pileDataMap.isEmpty()) {
            for (Map.Entry<UUID, CrateStackHandler> entry : this.pileDataMap.entrySet()) {
                nbt.func_218657_a(entry.getKey().toString(), (INBT)entry.getValue().serializeNBT());
            }
        }
        return nbt;
    }
}

