/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.network;

import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateCrateMessage {
    private final BlockPos pos;
    private final int numCrates;
    private final int capacity;

    public UpdateCrateMessage(BlockPos pos, int numCrates, int capacity) {
        this.pos = pos;
        this.numCrates = numCrates;
        this.capacity = capacity;
    }

    public static UpdateCrateMessage decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        int numCrates = buffer.readInt();
        int capacity = buffer.readInt();
        return new UpdateCrateMessage(pos, numCrates, capacity);
    }

    public static void encode(UpdateCrateMessage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
        buffer.writeInt(message.numCrates);
        buffer.writeInt(message.capacity);
    }

    public static void handle(UpdateCrateMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientWorld world;
            TileEntity tileEntity;
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() && (tileEntity = (world = Minecraft.func_71410_x().field_71441_e).func_175625_s(message.pos)) instanceof TileEntityCrate) {
                TileEntityCrate crate = (TileEntityCrate)tileEntity;
                crate.setNumCrates(message.numCrates);
                crate.setCapacity(message.capacity);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

