/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import java.util.Random;

public class AlphaPerlinNoise {
    private final int[] permutations = new int[512];
    public final double offsetX;
    public final double offsetY;
    public final double offsetZ;

    public AlphaPerlinNoise(Random random) {
        this.offsetX = random.nextDouble() * 256.0;
        this.offsetY = random.nextDouble() * 256.0;
        this.offsetZ = random.nextDouble() * 256.0;
        for (int i = 0; i < 256; ++i) {
            this.permutations[i] = i;
        }
        for (int j = 0; j < 256; ++j) {
            int k = random.nextInt(256 - j) + j;
            int l = this.permutations[j];
            this.permutations[j] = this.permutations[k];
            this.permutations[k] = l;
            this.permutations[j + 256] = this.permutations[j];
        }
    }

    public double sample(double x, double y, double z) {
        double localX = x + this.offsetX;
        double localY = y + this.offsetY;
        double localZ = z + this.offsetZ;
        int floorX = (int)localX;
        int floorY = (int)localY;
        int floorZ = (int)localZ;
        if (localX < (double)floorX) {
            --floorX;
        }
        if (localY < (double)floorY) {
            --floorY;
        }
        if (localZ < (double)floorZ) {
            --floorZ;
        }
        int maskedX = floorX & 0xFF;
        int maskedY = floorY & 0xFF;
        int maskedZ = floorZ & 0xFF;
        double smoothedX = (localX -= (double)floorX) * localX * localX * (localX * (localX * 6.0 - 15.0) + 10.0);
        double smoothedY = (localY -= (double)floorY) * localY * localY * (localY * (localY * 6.0 - 15.0) + 10.0);
        double smoothedZ = (localZ -= (double)floorZ) * localZ * localZ * (localZ * (localZ * 6.0 - 15.0) + 10.0);
        int perm1 = this.permutations[maskedX] + maskedY;
        int perm2 = this.permutations[perm1] + maskedZ;
        int perm3 = this.permutations[perm1 + 1] + maskedZ;
        int perm4 = this.permutations[maskedX + 1] + maskedY;
        int perm5 = this.permutations[perm4] + maskedZ;
        int perm6 = this.permutations[perm4 + 1] + maskedZ;
        return this.lerp(smoothedZ, this.lerp(smoothedY, this.lerp(smoothedX, this.grad(this.permutations[perm2], localX, localY, localZ), this.grad(this.permutations[perm5], localX - 1.0, localY, localZ)), this.lerp(smoothedX, this.grad(this.permutations[perm3], localX, localY - 1.0, localZ), this.grad(this.permutations[perm6], localX - 1.0, localY - 1.0, localZ))), this.lerp(smoothedY, this.lerp(smoothedX, this.grad(this.permutations[perm2 + 1], localX, localY, localZ - 1.0), this.grad(this.permutations[perm5 + 1], localX - 1.0, localY, localZ - 1.0)), this.lerp(smoothedX, this.grad(this.permutations[perm3 + 1], localX, localY - 1.0, localZ - 1.0), this.grad(this.permutations[perm6 + 1], localX - 1.0, localY - 1.0, localZ - 1.0))));
    }

    public double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public double grad(int i, double d, double d1, double d2) {
        double d3;
        int j = i & 0xF;
        double d4 = d3 = j >= 8 ? d1 : d;
        double d42 = j >= 4 ? (j != 12 && j != 14 ? d2 : d) : d1;
        return ((j & 1) != 0 ? -d3 : d3) + ((j & 2) != 0 ? -d42 : d42);
    }

    public double sample(double x, double z) {
        return this.sample(x, z, 0.0);
    }

    public double sample(double x, double y, double z, double freqX, double freqY, double freqZ, double amplitude) {
        double noiseAmplitude = 1.0 / amplitude;
        double localX = (x + 0.0) * freqX + this.offsetX;
        int floorX = (int)localX;
        if (localX < (double)floorX) {
            --floorX;
        }
        int maskX = floorX & 0xFF;
        double smoothedX = (localX -= (double)floorX) * localX * localX * (localX * (localX * 6.0 - 15.0) + 10.0);
        double localZ = (z + 0.0) * freqZ + this.offsetZ;
        int floorZ = (int)localZ;
        if (localZ < (double)floorZ) {
            --floorZ;
        }
        int maskZ = floorZ & 0xFF;
        double smoothZ = (localZ -= (double)floorZ) * localZ * localZ * (localZ * (localZ * 6.0 - 15.0) + 10.0);
        double localY = (y + 0.0) * freqY + this.offsetY;
        int floorY = (int)localY;
        if (localY < (double)floorY) {
            --floorY;
        }
        int maskY = floorY & 0xFF;
        double smoothY = (localY -= (double)floorY) * localY * localY * (localY * (localY * 6.0 - 15.0) + 10.0);
        int perm1 = this.permutations[maskX] + maskY;
        int perm2 = this.permutations[perm1] + maskZ;
        int perm3 = this.permutations[perm1 + 1] + maskZ;
        int perm4 = this.permutations[maskX + 1] + maskY;
        int perm5 = this.permutations[perm4] + maskZ;
        int perm6 = this.permutations[perm4 + 1] + maskZ;
        double lerp1 = this.lerp(smoothedX, this.grad(this.permutations[perm2], localX, localY, localZ), this.grad(this.permutations[perm5], localX - 1.0, localY, localZ));
        double lerp2 = this.lerp(smoothedX, this.grad(this.permutations[perm3], localX, localY - 1.0, localZ), this.grad(this.permutations[perm6], localX - 1.0, localY - 1.0, localZ));
        double lerp3 = this.lerp(smoothedX, this.grad(this.permutations[perm2 + 1], localX, localY, localZ - 1.0), this.grad(this.permutations[perm5 + 1], localX - 1.0, localY, localZ - 1.0));
        double lerp4 = this.lerp(smoothedX, this.grad(this.permutations[perm3 + 1], localX, localY - 1.0, localZ - 1.0), this.grad(this.permutations[perm6 + 1], localX - 1.0, localY - 1.0, localZ - 1.0));
        double biLerp1 = this.lerp(smoothY, lerp1, lerp2);
        double biLerp2 = this.lerp(smoothY, lerp3, lerp4);
        double finalNoise = this.lerp(smoothZ, biLerp1, biLerp2);
        return finalNoise * noiseAmplitude;
    }
}

