/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SmallBrownMushroomFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_196658_i || world.func_180495_p(pos).func_177230_c() == Blocks.field_150391_bh;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_177230_c() instanceof BushBlock;

    public SmallBrownMushroomFeature(Codec<NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos startPos, NoFeatureConfig config) {
        while (startPos.func_177956_o() > 1 && this.replace.matches((IWorld)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches((IWorld)world, startPos.func_177982_a(0, 0, 0))) {
            return false;
        }
        if (!this.checkSpace((IWorld)world, startPos.func_177984_a())) {
            return false;
        }
        BlockPos pos = startPos.func_177984_a();
        int height = 1 + rand.nextInt(2);
        for (int y = 0; y < height; ++y) {
            this.setBlock((IWorld)world, pos.func_177981_b(y), Blocks.field_196706_do.func_176223_P());
        }
        this.setBlock((IWorld)world, pos.func_177982_a(0, height, 0), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        this.setBlock((IWorld)world, pos.func_177982_a(-1, height, 0), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        this.setBlock((IWorld)world, pos.func_177982_a(1, height, 0), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        this.setBlock((IWorld)world, pos.func_177982_a(0, height, -1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        this.setBlock((IWorld)world, pos.func_177982_a(0, height, 1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        if (rand.nextInt(2) == 0) {
            this.setBlock((IWorld)world, pos.func_177982_a(1, height, 1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
            this.setBlock((IWorld)world, pos.func_177982_a(-1, height, -1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        } else {
            this.setBlock((IWorld)world, pos.func_177982_a(-1, height, 1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
            this.setBlock((IWorld)world, pos.func_177982_a(1, height, -1), (BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false)));
        }
        return true;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.func_230367_a_((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(IWorld world, BlockPos pos) {
        for (int y = 0; y <= 4; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

