/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BlockChanceCube;
import chanceCubes.config.CCubesSettings;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.sounds.CustomSoundsLoader;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.HTTPUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Level;

public class CustomRewardsLoader {
    public static CustomRewardsLoader instance;
    private static JsonParser json;
    private final File folder;

    public CustomRewardsLoader(File folder) {
        instance = this;
        this.folder = folder;
        json = new JsonParser();
        CustomSoundsLoader customSounds = new CustomSoundsLoader(folder, new File(folder.getAbsolutePath() + "/CustomSounds-Resourcepack"), "Chance Cubes Resource Pack");
        customSounds.addCustomSounds();
        try {
            customSounds.assemble();
        }
        catch (Exception e) {
            e.printStackTrace();
            CCubesCore.logger.log(Level.ERROR, "Chance Cubes failed to create a file or folder necessary to have custom sound rewards. No custom sounds will be added.");
        }
    }

    public void loadCustomRewards() {
        for (File f : this.folder.listFiles()) {
            JsonElement fileJson;
            if (!f.isFile() || !f.getName().contains(".json") || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            try {
                CCubesCore.logger.log(Level.INFO, "Loading custom rewards file " + f.getName());
                fileJson = json.parse((Reader)new FileReader(f));
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Unable to parse the file " + f.getName() + ". Skipping file loading.");
                CCubesCore.logger.log(Level.ERROR, "Parse Error: " + e.getMessage());
                continue;
            }
            int addedRewards = 0;
            for (Map.Entry reward : fileJson.getAsJsonObject().entrySet()) {
                CustomEntry<BasicReward, Boolean> parsedReward = RewardParser.parseReward(reward);
                BasicReward basicReward = parsedReward.getKey();
                if (basicReward == null) {
                    CCubesCore.logger.log(Level.ERROR, "Seems your reward is setup incorrectly, or is disabled for this version of minecraft with a depedency, and Chance Cubes was not able to parse the reward " + (String)reward.getKey() + " for the file " + f.getName());
                    continue;
                }
                if (parsedReward.getValue().booleanValue()) {
                    GlobalCCRewardRegistry.GIANT.registerReward(basicReward);
                } else {
                    GlobalCCRewardRegistry.DEFAULT.registerReward(basicReward);
                }
                ++addedRewards;
            }
            CCubesCore.logger.log(Level.INFO, "Loaded custom rewards file " + f.getName() + "! Added " + addedRewards + " rewards");
        }
        try {
            String today = new SimpleDateFormat("MM/dd").format(new Date());
            String ver = ((ModContainer)ModList.get().getModContainerById("chancecubes").get()).getModInfo().getVersion().toString();
            JsonObject json = HTTPUtil.makeAPIReq("GET", "chancecubes/rewards?version=" + ver + "&date=" + today, new CustomEntry[0]).getAsJsonObject();
            if (json.isJsonNull()) {
                CCubesCore.logger.log(Level.ERROR, "Failed to fetch remote information for the mod!");
                return;
            }
            this.loadDisabledRewards(json.get("Disabled Rewards").getAsJsonArray());
            this.loadHolidayRewards(json.get("Holiday Rewards"));
        }
        catch (Exception e) {
            CCubesCore.logger.log(Level.ERROR, "Failed to fetch remote information for the mod!");
            e.printStackTrace();
        }
    }

    private void loadHolidayRewards(JsonElement json) {
        if (!((Boolean)CCubesSettings.holidayRewards.get()).booleanValue()) {
            return;
        }
        JsonObject holidays = json.getAsJsonObject();
        if (holidays.has("Texture") && !(holidays.get("Texture") instanceof JsonNull)) {
            CCubesSettings.hasHolidayTexture = true;
            CCubesSettings.holidayTextureName = holidays.get("Texture").getAsString();
        } else {
            CCubesSettings.hasHolidayTexture = false;
            CCubesSettings.holidayTextureName = "default";
        }
        for (BlockChanceCube.EnumTexture t : BlockChanceCube.EnumTexture.values()) {
            if (!t.getName().equalsIgnoreCase(CCubesSettings.holidayTextureName)) continue;
            BlockChanceCube.textureToSet = t;
        }
        if (!((Boolean)CCubesSettings.holidayRewardTriggered.get()).booleanValue() && holidays.has("Holiday") && !(holidays.get("Holiday") instanceof JsonNull) && holidays.has("Reward") && !(holidays.get("Reward") instanceof JsonNull)) {
            String holidayName = holidays.get("Holiday").getAsString();
            BasicReward basicReward = RewardParser.parseReward(new CustomEntry<String, JsonElement>(holidayName, holidays.get("Reward"))).getKey();
            if (basicReward != null) {
                CCubesSettings.doesHolidayRewardTrigger = true;
                CCubesSettings.holidayReward = basicReward;
                CCubesCore.logger.log(Level.INFO, "Custom holiday reward \"" + holidayName + "\" loaded!");
            } else {
                CCubesCore.logger.log(Level.ERROR, "Failed to load the Custom holiday reward \"" + holidayName + "\"!");
            }
        }
    }

    private void loadDisabledRewards(JsonArray disabledRewards) {
        if (((Boolean)CCubesSettings.disabledRewards.get()).booleanValue()) {
            for (JsonElement reward : disabledRewards) {
                boolean removed = GlobalCCRewardRegistry.DEFAULT.unregisterReward(reward.getAsString());
                if (!removed) {
                    removed = GlobalCCRewardRegistry.GIANT.unregisterReward(reward.getAsString());
                }
                if (!removed) continue;
                CCubesCore.logger.log(Level.WARN, "The reward " + reward.getAsString() + " has been disabled by the mod author due to a bug or some other reason.");
            }
        }
    }
}

