/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry.global;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.registry.global.GlobalRewardInfo;
import chanceCubes.registry.player.PlayerCCRewardRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.CustomUserReward;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;

public class GlobalCCRewardRegistry {
    public static GlobalCCRewardRegistry DEFAULT = new GlobalCCRewardRegistry();
    public static GlobalCCRewardRegistry GIANT = new GlobalCCRewardRegistry();
    private final Map<String, GlobalRewardInfo> nameToReward = new HashMap<String, GlobalRewardInfo>();
    private final Map<String, PlayerCCRewardRegistry> playerToRewards = new HashMap<String, PlayerCCRewardRegistry>();

    public static void loadCustomUserRewards(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            CustomUserReward.getCustomUserReward(player.m_142081_());
        }
    }

    public void registerReward(IChanceCubeReward reward) {
        this.registerReward(reward, true);
    }

    public void registerReward(IChanceCubeReward reward, boolean defaultVal) {
        if (ConfigLoader.getRewardConfigStatus(reward.getName(), defaultVal) && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), new GlobalRewardInfo(reward, true));
        }
    }

    public boolean unregisterReward(String name) {
        for (PlayerCCRewardRegistry playerRewards : this.playerToRewards.values()) {
            playerRewards.disableReward(name);
        }
        return this.nameToReward.remove(name) != null;
    }

    public void removePlayerRewards(String playerUUID) {
        this.playerToRewards.remove(playerUUID);
    }

    public boolean enableReward(String rewardName) {
        IChanceCubeReward reward = this.getRewardByName(rewardName);
        if (reward != null) {
            return this.enableReward(reward);
        }
        return false;
    }

    public boolean enableReward(IChanceCubeReward reward) {
        String rewardName;
        if (reward != null && this.nameToReward.containsKey(rewardName = reward.getName()) && !this.nameToReward.get((Object)rewardName).enabled) {
            this.nameToReward.get((Object)rewardName).enabled = true;
            for (Map.Entry<String, PlayerCCRewardRegistry> registry : this.playerToRewards.entrySet()) {
                if (reward instanceof CustomUserReward && !((CustomUserReward)reward).getUuid().toString().equals(registry.getKey())) continue;
                registry.getValue().enableReward(reward);
            }
            return true;
        }
        return false;
    }

    public boolean disableReward(String rewardName) {
        IChanceCubeReward reward = this.getRewardByName(rewardName);
        if (reward != null) {
            return this.disableReward(reward);
        }
        return false;
    }

    public boolean disableReward(IChanceCubeReward reward) {
        String rewardName;
        if (reward != null && this.nameToReward.containsKey(rewardName = reward.getName()) && this.nameToReward.get((Object)rewardName).enabled) {
            this.nameToReward.get((Object)rewardName).enabled = false;
            for (PlayerCCRewardRegistry registry : this.playerToRewards.values()) {
                registry.disableReward(reward);
            }
            return true;
        }
        return false;
    }

    public boolean isRewardEnabled(String reward) {
        return this.isValidRewardName(reward) && this.nameToReward.get((Object)reward).enabled;
    }

    public boolean isValidRewardName(String reward) {
        return this.nameToReward.containsKey(reward);
    }

    public IChanceCubeReward getRewardByName(String name) {
        if (this.nameToReward.containsKey(name)) {
            return this.nameToReward.get((Object)name).reward;
        }
        return null;
    }

    public Set<String> getRewardNames() {
        return this.nameToReward.keySet();
    }

    public PlayerCCRewardRegistry getPlayerRewardRegistry(String playerUUID) {
        return this.playerToRewards.computeIfAbsent(playerUUID, k -> {
            PlayerCCRewardRegistry playerRewardRegistry = new PlayerCCRewardRegistry();
            for (GlobalRewardInfo reward : this.nameToReward.values()) {
                if (!reward.enabled || reward.reward instanceof CustomUserReward && !((CustomUserReward)reward.reward).getUuid().toString().equals(playerUUID)) continue;
                playerRewardRegistry.enableReward(reward.reward);
            }
            return playerRewardRegistry;
        });
    }

    public void triggerRandomReward(ServerLevel world, BlockPos pos, Player player, int chance) {
        if (CCubesSettings.testRewards) {
            CCubesCore.logger.log(Level.INFO, "This feature has been temporarily removed!");
            return;
        }
        if (CCubesSettings.testCustomRewards) {
            CCubesCore.logger.log(Level.INFO, "This feature has been temporarily removed!");
            return;
        }
        if (CCubesSettings.doesHolidayRewardTrigger && CCubesSettings.holidayReward != null) {
            GlobalCCRewardRegistry.triggerReward(CCubesSettings.holidayReward, world, pos, player);
            CCubesCore.logger.log(Level.INFO, "The " + CCubesSettings.holidayReward.getName() + " holiday reward has been triggered!!!!");
            CCubesSettings.doesHolidayRewardTrigger = false;
            CCubesSettings.holidayRewardTriggered.set((Object)true);
            return;
        }
        if (player != null) {
            this.getPlayerRewardRegistry(player.m_20149_()).triggerRandomReward(world, pos, player, chance);
        }
    }

    public static void triggerReward(IChanceCubeReward reward, ServerLevel world, BlockPos pos, Player player) {
        JsonObject settings = ConfigLoader.getRewardSettings(reward.getName());
        reward.trigger(world, pos, player, settings);
    }

    public int getNumberOfLoadedRewards() {
        return this.nameToReward.size();
    }

    public void ClearRewards() {
        this.nameToReward.clear();
        this.playerToRewards.clear();
    }
}

