/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.renderer;

import chanceCubes.tileentities.TileGiantCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class TileGiantCubeRenderer
implements BlockEntityRenderer<TileGiantCube> {
    private static final Map<Direction, ResourceLocation> GCC_TEXTURES = new HashMap<Direction, ResourceLocation>();

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().m_118330_().equals((Object)Sheets.f_110740_)) {
            for (ResourceLocation res : GCC_TEXTURES.values()) {
                event.addSprite(res);
            }
        }
    }

    public void render(TileGiantCube tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int light, int overlayLight) {
        if (!tile.isMaster()) {
            return;
        }
        poseStack.m_85836_();
        int lightToUse = light;
        if (tile.m_58904_() != null) {
            lightToUse = tile.m_58904_().m_7146_(tile.m_58899_().m_142082_(0, 2, 0)) * 100;
        }
        for (Direction side : Direction.values()) {
            Material materialInterface = new Material(Sheets.f_110740_, GCC_TEXTURES.get(side));
            VertexConsumer buffer = materialInterface.m_119194_(bufferIn, RenderType::m_110497_);
            TextureAtlasSprite sprite = materialInterface.m_119204_();
            poseStack.m_85836_();
            poseStack.m_85837_(-1.0, -1.0, -1.0);
            poseStack.m_85841_(0.1875f, -0.1875f, 0.1875f);
            float translateX = side.m_122429_();
            float translateY = side.m_122430_() - 1;
            float translateZ = side.m_122431_();
            int rotationY = 0;
            int rotationX = 0;
            switch (side) {
                case NORTH: {
                    translateZ += 1.0f;
                    translateX += 1.0f;
                    rotationY = 180;
                    break;
                }
                case EAST: {
                    translateZ += 1.0f;
                    rotationY = 90;
                    break;
                }
                case WEST: {
                    translateX += 1.0f;
                    rotationY = -90;
                    break;
                }
                case UP: {
                    translateZ += 1.0f;
                    rotationX = -90;
                    break;
                }
                case SOUTH: {
                    break;
                }
                case DOWN: {
                    rotationX = 90;
                    translateY += 1.0f;
                }
            }
            poseStack.m_85837_((double)(translateX * 16.0f), (double)(translateY * 16.0f), (double)(translateZ * 16.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)rotationY));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)rotationX));
            int r = 255;
            int g = 255;
            int b = 255;
            int a = 255;
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            buffer.m_85982_(matrix, 16.0f, 16.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(lightToUse).m_5752_();
            buffer.m_85982_(matrix, 16.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(lightToUse).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(lightToUse).m_5752_();
            buffer.m_85982_(matrix, 0.0f, 16.0f, 0.0f).m_6122_(r, g, b, a).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(lightToUse).m_5752_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileGiantCube tile) {
        return true;
    }

    static {
        GCC_TEXTURES.put(Direction.UP, new ResourceLocation("chancecubes", "blocks/chance_cube_face_1"));
        GCC_TEXTURES.put(Direction.NORTH, new ResourceLocation("chancecubes", "blocks/chance_cube_face_2"));
        GCC_TEXTURES.put(Direction.EAST, new ResourceLocation("chancecubes", "blocks/chance_cube_face_3"));
        GCC_TEXTURES.put(Direction.WEST, new ResourceLocation("chancecubes", "blocks/chance_cube_face_4"));
        GCC_TEXTURES.put(Direction.SOUTH, new ResourceLocation("chancecubes", "blocks/chance_cube_face_5"));
        GCC_TEXTURES.put(Direction.DOWN, new ResourceLocation("chancecubes", "blocks/chance_cube_face_6"));
    }
}

