/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.ArmorStandArmorReward;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BookOfMemesReward;
import chanceCubes.rewards.defaultRewards.BossBlazeReward;
import chanceCubes.rewards.defaultRewards.BossMimicReward;
import chanceCubes.rewards.defaultRewards.BossRavagerReward;
import chanceCubes.rewards.defaultRewards.BossWitchReward;
import chanceCubes.rewards.defaultRewards.CakeIsALieReward;
import chanceCubes.rewards.defaultRewards.ChanceCubeRenameReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CoinFlipReward;
import chanceCubes.rewards.defaultRewards.Connect4Reward;
import chanceCubes.rewards.defaultRewards.CountDownReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.CursedHeadReward;
import chanceCubes.rewards.defaultRewards.DidYouKnowReward;
import chanceCubes.rewards.defaultRewards.DigBuildReward;
import chanceCubes.rewards.defaultRewards.DoubleRainbow;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.ItemChestReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.ItemRenamer;
import chanceCubes.rewards.defaultRewards.JarGuessReward;
import chanceCubes.rewards.defaultRewards.JukeBoxReward;
import chanceCubes.rewards.defaultRewards.LootBoxReward;
import chanceCubes.rewards.defaultRewards.MagicFeetReward;
import chanceCubes.rewards.defaultRewards.MatchingReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.MazeReward;
import chanceCubes.rewards.defaultRewards.MobTowerReward;
import chanceCubes.rewards.defaultRewards.MontyHallReward;
import chanceCubes.rewards.defaultRewards.OneIsLuckyReward;
import chanceCubes.rewards.defaultRewards.QuestionsReward;
import chanceCubes.rewards.defaultRewards.RainingCatsAndCogsReward;
import chanceCubes.rewards.defaultRewards.SkyblockReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.TableFlipReward;
import chanceCubes.rewards.defaultRewards.TicTacToeReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WheelSpinReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.defaultRewards.WolvesToCreepersReward;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.OffsetTileEntity;
import chanceCubes.rewards.rewardparts.SchematicPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.CommandRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.rewards.rewardtype.SoundRewardType;
import chanceCubes.rewards.variableTypes.BoolVar;
import chanceCubes.rewards.variableTypes.FloatVar;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;

public class DefaultRewards {
    public static void loadDefaultRewards() {
        RewardsUtil.initData();
        if (!((Boolean)CCubesSettings.enableHardCodedRewards.get()).booleanValue()) {
            return;
        }
        for (String fileName : RewardsUtil.getHardcodedRewards()) {
            JsonObject json = RewardsUtil.getRewardJson(fileName);
            for (Map.Entry reward : json.entrySet()) {
                boolean defaultEnable;
                CustomEntry<BasicReward, Boolean> parsedReward = RewardParser.parseReward(reward);
                BasicReward basicReward = parsedReward.getKey();
                if (basicReward == null) {
                    CCubesCore.logger.error("A hard coded reward failed to parse! Please report this to the mod dev! " + (String)reward.getKey() + " for the file " + fileName);
                    continue;
                }
                boolean bl = defaultEnable = !basicReward.getName().equalsIgnoreCase("chancecubes:giant_chance_cube");
                if (parsedReward.getValue().booleanValue()) {
                    GlobalCCRewardRegistry.GIANT.registerReward(basicReward);
                    continue;
                }
                GlobalCCRewardRegistry.DEFAULT.registerReward(basicReward, defaultEnable);
            }
        }
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:lava_ring", -40, new BlockRewardType(new OffsetBlock(1, -1, 0, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, Blocks.f_49991_, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, Blocks.f_49991_, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:rain", -5, new CommandRewardType("/weather thunder 20000")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:silverfish_surround", -20, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.f_50227_, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 0, Blocks.f_50227_, false).setRelativeToPlayer(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fish_dog", 20, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.f_42526_, 5)), new ItemPart(new ItemStack((ItemLike)Items.f_42606_)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:bone_cat", 20, new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.f_42500_, 5)), new ItemPart(new ItemStack((ItemLike)Items.f_42626_)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_cat", -25, new CommandRewardType("/summon ocelot ~ ~1 ~ {CatType:0,Sitting:0,Passengers:[{id:\"tnt\",Fuse:80}]}")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:diamond_block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.f_50090_, true, 200))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:tnt_diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.f_50090_, false), new OffsetBlock(0, -1, 0, Blocks.f_50090_, false), new OffsetBlock(1, 0, 0, Blocks.f_50090_, false), new OffsetBlock(-1, 0, 0, Blocks.f_50090_, false), new OffsetBlock(0, 0, 1, Blocks.f_50090_, false), new OffsetBlock(0, 0, -1, Blocks.f_50090_, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:fake_tnt", 0, new SoundRewardType(new SoundPart(SoundEvents.f_12512_), new SoundPart(SoundEvents.f_12512_), new SoundPart(SoundEvents.f_12512_), new SoundPart(SoundEvents.f_11913_, 120).setAtPlayersLocation(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:invisible_ghasts", 0, new SoundRewardType(new SoundPart(SoundEvents.f_11922_).setServerWide(true), new SoundPart(SoundEvents.f_11924_).setServerWide(true), new SoundPart(SoundEvents.f_11924_).setServerWide(true))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:no", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, (Block)CCubesBlocks.CHANCE_CUBE, false)), new MessageRewardType("No")));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:coal_to_diamonds", 10, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.f_50353_, false), new OffsetBlock(0, -1, 0, Blocks.f_50353_, false), new OffsetBlock(1, 0, 0, Blocks.f_50353_, false), new OffsetBlock(-1, 0, 0, Blocks.f_50353_, false), new OffsetBlock(0, 0, 1, Blocks.f_50353_, false), new OffsetBlock(0, 0, -1, Blocks.f_50353_, false)), new CommandRewardType(RewardsUtil.executeXCommands("/summon tnt %x %y %z {Fuse:40}", 3, 5)), new ItemRewardType(new ItemPart(new ItemStack((ItemLike)Items.f_42415_, 5), 50))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:one_man_army", -10, new EntityRewardType("zombified_piglin"), new CommandRewardType(RewardsUtil.executeXCommands("/summon zombified_piglin ~ ~ ~ {Silent:1,ActiveEffects:[{Id:14,Amplifier:0,Duration:19980,ShowParticles:1b}]}", 9)), new MessageRewardType(new MessagePart("One man army").setRange(32))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:arrow_trap", -25, new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/arrow_trap.ccs", true, new IntVar(1), new IntVar(-1), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0)))));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:trampoline", 15, new MessageRewardType("Time to bounce!"), new SchematicRewardType(new SchematicPart("/data/chancecubes/schematics/trampoline.ccs", true, new IntVar(1), new IntVar(-3), new IntVar(1), new FloatVar(0.0f), new BoolVar(false), new BoolVar(true), new BoolVar(true), new BoolVar(true), new IntVar(0))), new BlockRewardType(new OffsetBlock(2, -2, -2, Blocks.f_50330_, false, 3).setRelativeToPlayer(true).setCausesBlockUpdate(true), new OffsetBlock(2, -2, -2, Blocks.f_50088_, false, 5).setRelativeToPlayer(true).setCausesBlockUpdate(true))));
        SignBlockEntity sign = BlockWrapper.createSign(new BlockPos(0, 0, 0), new String[]{"The broken path", "to succeed"});
        CompoundTag nbt = new CompoundTag();
        sign.m_6945_(nbt);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:path_to_succeed", 0, new BlockRewardType(new OffsetBlock[]{new OffsetTileEntity(0, 0, -5, Blocks.f_50095_, nbt, true, 20), new OffsetBlock(0, -1, 0, Blocks.f_50652_, true, 0), new OffsetBlock(0, -1, -1, Blocks.f_50652_, true, 4), new OffsetBlock(0, -1, -2, Blocks.f_50652_, true, 8), new OffsetBlock(0, -1, -3, Blocks.f_50652_, true, 12), new OffsetBlock(0, -1, -4, Blocks.f_50652_, true, 16), new OffsetBlock(0, -1, -5, Blocks.f_50652_, true, 20)})));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.f_50075_, true, i * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, Blocks.f_50273_, true, 200);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BasicReward("chancecubes:beacon_build", 100, new BlockRewardType(blocks)));
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:half_heart", -30){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                player.m_21153_(1.0f);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:no_exp", -40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                player.f_36078_ = 0;
                player.f_36079_ = 0;
                player.f_36080_ = 0.0f;
                RewardsUtil.sendMessageToPlayer(player, "Rip EXP");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:smite", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                EntityWrapper.spawnLightning((Level)level, player.m_20097_());
                RewardsUtil.sendMessageToPlayer(player, "Thou has been smitten!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:cookie-splosion", 35){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        ItemEntity cookie = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42572_));
                        level.m_7967_((Entity)cookie);
                        cookie.m_20334_(xx, Math.random(), zz);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_status_effect", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                RewardsUtil.sendMessageToPlayer(player, "Selecting random potion effect to apply...");
                Scheduler.scheduleTask(new Task("Cookie Monster", 30){

                    @Override
                    public void callback() {
                        MobEffectInstance effect = RewardsUtil.getRandomPotionEffectInstance();
                        RewardsUtil.sendMessageToPlayer(player, "You have been given: ");
                        RewardsUtil.sendMessageToPlayer(player, (Component)new TranslatableComponent(effect.m_19576_()));
                        RewardsUtil.sendMessageToPlayer(player, "for " + effect.m_19557_() / 20 + " seconds!");
                        player.m_7292_(effect);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:arrow_spray", -15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double xx = 1.0; xx > -1.0; xx -= 0.25) {
                    for (double zz = 1.0; zz > -1.0; zz -= 0.25) {
                        Arrow arrow = new Arrow((Level)level, (LivingEntity)player);
                        arrow.m_7678_((double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_(), 0.0f, 0.0f);
                        arrow.m_20334_(xx, 0.3, zz);
                        level.m_7967_((Entity)arrow);
                    }
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:lingering_potions_ring", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (double rad = -Math.PI; rad <= Math.PI; rad += 0.3141592653589793) {
                    ThrownPotion pot = new ThrownPotion((Level)level, (LivingEntity)player);
                    pot.m_37446_(PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), List.of(RewardsUtil.getRandomPotionEffectInstance())));
                    pot.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                    pot.m_20334_(Math.cos(rad) * 0.25, 1.0, Math.sin(rad) * 0.25);
                    level.m_7967_((Entity)pot);
                }
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:charged_creeper", -40){

            @Override
            public void trigger(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                if (level.m_5776_()) {
                    return;
                }
                RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), (Level)level, pos.m_142082_(0, 1, 0));
                final Creeper ent = (Creeper)EntityType.f_20558_.m_20615_((Level)level);
                ent.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                ent.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 99, true, false));
                ent.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 99, true, false));
                level.m_7967_((Entity)ent);
                Scheduler.scheduleTask(new Task("Charged Creeper Reward", 2){

                    @Override
                    public void callback() {
                        EntityWrapper.spawnLightning((Level)level, player.m_20097_());
                        ent.m_20095_();
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:disco", 40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int xx = -4; xx < 5; ++xx) {
                    for (int zz = -4; zz < 5; ++zz) {
                        RewardsUtil.placeBlock(RewardsUtil.getRandomWool(), (Level)level, pos.m_142082_(xx, -1, zz));
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    Sheep sheep = (Sheep)EntityType.f_20520_.m_20615_((Level)level);
                    sheep.m_6593_((Component)new TextComponent("jeb_"));
                    sheep.m_7678_((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.0f, 0.0f);
                    level.m_7967_((Entity)sheep);
                }
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.m_49966_(), (Level)level, pos.m_142082_(0, 3, 0));
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "Disco Party!!!!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:ender_crystal_timer", -90){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int i = 30; i > 0; --i) {
                    RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), (Level)level, pos.m_142082_(0, i, 0));
                }
                EndCrystal ent = (EndCrystal)EntityType.f_20564_.m_20615_((Level)level);
                ent.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                level.m_7967_((Entity)ent);
                Arrow arrow = new Arrow((Level)level, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 29), (double)pos.m_123343_() + 0.5);
                arrow.m_20334_(0.0, -0.25, 0.0);
                level.m_7967_((Entity)arrow);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:5_prongs", -10){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int xx = pos.m_123341_() - 3; xx <= pos.m_123341_() + 3; ++xx) {
                    for (int zz = pos.m_123343_() - 3; zz <= pos.m_123343_() + 3; ++zz) {
                        for (int yy = pos.m_123342_(); yy <= pos.m_123342_() + 4; ++yy) {
                            RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), (Level)level, new BlockPos(xx, yy, zz));
                        }
                    }
                }
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos);
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos.m_142082_(0, 1, 0));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_ICOSAHEDRON.m_49966_(), (Level)level, pos.m_142082_(0, 2, 0));
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos.m_142082_(-3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.m_49966_(), (Level)level, pos.m_142082_(-3, 1, -3));
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos.m_142082_(-3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.m_49966_(), (Level)level, pos.m_142082_(-3, 1, 3));
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos.m_142082_(3, 0, -3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.m_49966_(), (Level)level, pos.m_142082_(3, 1, -3));
                RewardsUtil.placeBlock(Blocks.f_50333_.m_49966_(), (Level)level, pos.m_142082_(3, 0, 3));
                RewardsUtil.placeBlock(CCubesBlocks.CHANCE_CUBE.m_49966_(), (Level)level, pos.m_142082_(3, 1, 3));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:inventory_bomb", -55){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int i;
                player.m_150109_().m_36071_();
                for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    player.m_150109_().f_35974_.set(i, (Object)new ItemStack((ItemLike)Blocks.f_50036_, 64));
                }
                for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
                    ItemStack stack = new ItemStack((ItemLike)Blocks.f_50036_, 64);
                    if (i == 0) {
                        stack.m_41714_((Component)new TextComponent("Button").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE))));
                        stack.m_41764_(13);
                    } else if (i == 1) {
                        stack.m_41714_((Component)new TextComponent("TheBlackswordsman"));
                        stack.m_41764_(13);
                    }
                    player.m_150109_().f_35975_.set(i, (Object)stack);
                }
                RewardsUtil.sendMessageToPlayer(player, "Inventory Bomb!!!!");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:nuke", -75){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 32, "May death rain upon them");
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() - 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 2), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() - 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 6), (LivingEntity)player));
                level.m_7967_((Entity)new PrimedTnt((Level)level, (double)(pos.m_123341_() + 6), (double)(pos.m_123342_() + 65), (double)(pos.m_123343_() + 6), (LivingEntity)player));
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:random_teleport", -15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int xChange = level.f_46441_.nextInt(50) + 20 + pos.m_123341_() - 35;
                int zChange = level.f_46441_.nextInt(50) + 20 + pos.m_123343_() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= level.m_141928_(); ++yy) {
                    if (!level.m_8055_(new BlockPos(xChange, yy, zChange)).m_60795_() || !level.m_8055_(new BlockPos(xChange, yy + 1, zChange)).m_60795_()) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.m_6027_((double)xChange, (double)yChange, (double)zChange);
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:rotten_food", -30){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (stack.m_41619_() || !stack.m_41720_().m_41472_()) continue;
                    player.m_150109_().f_35974_.set(i, (Object)new ItemStack((ItemLike)Items.f_42583_, stack.m_41613_()));
                }
                RewardsUtil.sendMessageToPlayer(player, "Ewwww it's all rotten");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:thrown_in_air", -35){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                int px = (int)Math.floor(player.m_20185_());
                int py = (int)Math.floor(player.m_20186_()) + 1;
                int pz = (int)Math.floor(player.m_20189_());
                for (int y = 0; y < 40; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), (Level)level, pos.m_142082_(px + x, py + y, pz + z));
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("Thrown_In_Air_Reward", 5){

                    @Override
                    public void callback() {
                        player.m_20334_(0.0, 20.0, 0.0);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:torches_to_creepers", -40){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                for (int yy = -32; yy <= 32; ++yy) {
                    for (int xx = -32; xx <= 32; ++xx) {
                        for (int zz = -32; zz <= 32; ++zz) {
                            BlockState b = level.m_8055_(pos.m_142082_(xx, yy, zz));
                            if (b.getLightEmission((BlockGetter)level, pos) <= 0 || b.m_60734_() == Blocks.f_49991_ || b.m_155947_()) continue;
                            RewardsUtil.placeBlock(Blocks.f_50016_.m_49966_(), (Level)level, pos.m_142082_(xx, yy, zz));
                            Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)level);
                            creeper.m_7678_((double)(pos.m_123341_() + xx) + 0.5, (double)(pos.m_123342_() + yy), (double)(pos.m_123343_() + zz) + 0.5, 0.0f, 0.0f);
                            level.m_7967_((Entity)creeper);
                        }
                    }
                }
                RewardsUtil.sendMessageToPlayer(player, "Those lights seem a little weird.... O.o");
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:traveller", 15){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                int x = RewardsUtil.rand.nextInt(1000) + 200;
                int z = RewardsUtil.rand.nextInt(1000) + 200;
                BlockPos newPos = pos.m_142082_(x, 0, z);
                RewardsUtil.placeBlock((BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.WEST), (Level)level, newPos);
                ChestBlockEntity chest = (ChestBlockEntity)level.m_7702_(newPos);
                for (int i = 0; i < 10; ++i) {
                    chest.m_6836_(i, new ItemStack((ItemLike)RewardsUtil.getRandomItem()));
                }
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 25, newPos.m_123341_() + ", " + newPos.m_123342_() + ", " + newPos.m_123343_());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:troll_hole", -20){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                BlockPos worldPos = new BlockPos(Math.floor(player.m_20185_()), Math.floor(player.m_20186_()) - 1.0, Math.floor(player.m_20189_()));
                final RewardBlockCache cache = new RewardBlockCache((Level)level, worldPos, new BlockPos(worldPos.m_123341_(), worldPos.m_123342_() + 1, worldPos.m_123343_()));
                for (int y = 0; y > -75; --y) {
                    for (int x = -2; x < 3; ++x) {
                        for (int z = -2; z < 3; ++z) {
                            cache.cacheBlock(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                        }
                    }
                }
                Scheduler.scheduleTask(new Task("TrollHole", 35){

                    @Override
                    public void callback() {
                        cache.restoreBlocks((Entity)player);
                        player.f_19789_ = 0.0f;
                        player.m_20334_(0.0, 0.0, 0.0);
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:saw_nothing_diamond", 0){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
                final ItemEntity itemEnt = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42415_, 1));
                itemEnt.m_32062_();
                level.m_7967_((Entity)itemEnt);
                Scheduler.scheduleTask(new Task("Saw_Nothing_Diamond", 100){

                    @Override
                    public void callback() {
                        itemEnt.m_142687_(Entity.RemovalReason.DISCARDED);
                        RewardsUtil.sendMessageToPlayer(player, "You didn't see anything......");
                    }
                });
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BaseCustomReward("chancecubes:hand_enchant", 20){

            @Override
            public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
                ItemStack toEnchant;
                if (!player.m_21211_().m_41619_()) {
                    toEnchant = player.m_21211_();
                } else {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        if (stack.m_41619_()) continue;
                        stacks.add(stack);
                    }
                    for (ItemStack stack : player.m_150109_().f_35975_) {
                        if (stack.m_41619_()) continue;
                        stacks.add(stack);
                    }
                    if (stacks.size() == 0) {
                        ItemStack dirt = new ItemStack((ItemLike)Blocks.f_50493_);
                        dirt.m_41714_((Component)new TextComponent("A lonley piece of dirt"));
                        player.m_150109_().m_36054_(dirt);
                        RewardsUtil.executeCommand(level, player, (Vec3i)player.m_20097_(), "/advancement grant @p only chancecubes:lonely_dirt");
                        return;
                    }
                    toEnchant = (ItemStack)stacks.get(RewardsUtil.rand.nextInt(stacks.size()));
                }
                CustomEntry<Enchantment, Integer> enchantment = RewardsUtil.getRandomEnchantmentAndLevel();
                toEnchant.m_41663_(enchantment.getKey(), enchantment.getValue().intValue());
            }
        });
        GlobalCCRewardRegistry.DEFAULT.registerReward(new AnvilRain());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new HerobrineReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CreeperSurroundedReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WitherReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TrollTNTReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WaitForItReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ClearInventoryReward(), false);
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemOfDestinyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new JukeBoxReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BookOfMemesReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TableFlipReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new OneIsLuckyReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new SkyblockReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CakeIsALieReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemRenamer());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DoubleRainbow());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WolvesToCreepersReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DidYouKnowReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ArmorStandArmorReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new RainingCatsAndCogsReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ItemChestReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MagicFeetReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new DigBuildReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new ChanceCubeRenameReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CountDownReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MobTowerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MontyHallReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new MatchingReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new TicTacToeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossMimicReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossWitchReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossBlazeReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new BossRavagerReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new CursedHeadReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new WheelSpinReward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new Connect4Reward());
        GlobalCCRewardRegistry.DEFAULT.registerReward(new LootBoxReward());
        MathReward math = new MathReward();
        MinecraftForge.EVENT_BUS.register((Object)math);
        GlobalCCRewardRegistry.DEFAULT.registerReward(math);
        QuestionsReward question = new QuestionsReward();
        MinecraftForge.EVENT_BUS.register((Object)question);
        GlobalCCRewardRegistry.DEFAULT.registerReward(question);
        CoinFlipReward coinFlip = new CoinFlipReward();
        MinecraftForge.EVENT_BUS.register((Object)coinFlip);
        GlobalCCRewardRegistry.DEFAULT.registerReward(coinFlip);
        JarGuessReward jarGuess = new JarGuessReward();
        MinecraftForge.EVENT_BUS.register((Object)jarGuess);
        GlobalCCRewardRegistry.DEFAULT.registerReward(jarGuess);
    }
}

