/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.BasicTreesBiome;
import chanceCubes.rewards.biodomeGen.DesertBiome;
import chanceCubes.rewards.biodomeGen.EndBiome;
import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.biodomeGen.NetherBiome;
import chanceCubes.rewards.biodomeGen.OceanBiome;
import chanceCubes.rewards.biodomeGen.SnowGlobeBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BioDomeGen {
    public static final int delayShorten = 10;
    public static final IBioDomeBiome[] biomes = new IBioDomeBiome[]{new BasicTreesBiome("trees_plains"), new DesertBiome("desert"), new EndBiome("end"), new OceanBiome("ocean"), new SnowGlobeBiome("snow_globe"), new NetherBiome("nether")};
    private final Player player;
    private RewardBlockCache blockCache;
    private int yinc;
    private int xinc;
    private final List<String> blackListBiomes;

    public BioDomeGen(Player player) {
        this(player, new ArrayList<String>());
    }

    public BioDomeGen(Player player, List<String> blackListBiomes) {
        this.player = player;
        this.blackListBiomes = blackListBiomes;
    }

    public void genRandomDome(BlockPos pos, ServerLevel level, int radius, boolean spawnEntities) {
        IBioDomeBiome biome = biomes[0];
        List biomesFiltered = Arrays.stream(biomes).filter(line -> !this.blackListBiomes.contains(line.getBiomeName())).collect(Collectors.toList());
        if (biomesFiltered.size() != 0) {
            biome = (IBioDomeBiome)biomesFiltered.get(RewardsUtil.rand.nextInt(biomesFiltered.size()));
        }
        this.genDome(biome, pos, level, radius, spawnEntities);
    }

    public void genDome(IBioDomeBiome spawnedBiome, BlockPos pos, ServerLevel level, int radius, boolean spawnEntities) {
        this.yinc = 0;
        this.xinc = -radius;
        this.blockCache = new RewardBlockCache((Level)level, pos, this.player.m_20097_());
        this.genDomePart(spawnedBiome, pos, level, radius, spawnEntities);
    }

    private void genDomePart(final IBioDomeBiome spawnedBiome, final BlockPos pos, final ServerLevel level, final int radius, final boolean spawnEntities) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int z = -radius; z <= radius; ++z) {
            BlockPos loc = new BlockPos(this.xinc, this.yinc, z);
            float dist = (float)(Math.sqrt(Math.abs(loc.m_123299_(0.0, 0.0, 0.0, false))) - (double)radius);
            if (!(dist < 1.0f)) continue;
            if (dist >= 0.0f) {
                blocks.add(new OffsetBlock(this.xinc, this.yinc, z, Blocks.f_50058_, false, delay / 10));
                ++delay;
            } else if (this.yinc == 0) {
                blocks.add(new OffsetBlock(this.xinc, this.yinc, z, spawnedBiome.getFloorBlock(), false, delay / 10));
                ++delay;
            }
            spawnedBiome.getRandomGenBlock(dist, RewardsUtil.rand, this.xinc, this.yinc, z, blocks, delay);
        }
        this.xinc = this.xinc + 1 > radius ? -radius : this.xinc + 1;
        int yIncTemp = this.yinc;
        if (this.xinc == -radius) {
            int n = yIncTemp = yIncTemp + 1 > radius ? -1 : yIncTemp + 1;
        }
        if (yIncTemp == -1) {
            if (spawnEntities) {
                Scheduler.scheduleTask(new Task("Entity_Delays", delay){

                    @Override
                    public void callback() {
                        spawnedBiome.spawnEntities(pos, level);
                    }
                });
            }
            if (spawnedBiome instanceof OceanBiome) {
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 1200));
            }
            return;
        }
        this.yinc = yIncTemp;
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.blockCache);
        }
        Scheduler.scheduleTask(new Task("BioDome Reward", delay / 10){

            @Override
            public void callback() {
                BioDomeGen.this.genDomePart(spawnedBiome, pos, level, radius, spawnEntities);
            }
        });
    }

    public void removeDome(boolean resetPlayer) {
        this.blockCache.restoreBlocks((Entity)(resetPlayer ? this.player : null));
    }
}

