/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.biodomeGen.BioDomeGen;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class BossBaseReward
extends BaseCustomReward {
    private final String bossName;

    public BossBaseReward(String bossName) {
        super("chancecubes:boss_" + bossName, -35);
        this.bossName = bossName.replace("_", " ");
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, final JsonObject settings) {
        final BattleWrapper battleWrapper = new BattleWrapper();
        battleWrapper.rewardCenterPos = pos;
        battleWrapper.domeGen = new BioDomeGen(player);
        battleWrapper.domeGen.genRandomDome(pos.m_142082_(0, -1, 0), level, 15, false);
        TextComponent message = new TextComponent("BOSS FIGHT!");
        message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
        RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.TITLE, (Component)message, 10, 500, 0);
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_1", 120){

            @Override
            public void callback() {
                TextComponent message = new TextComponent("");
                message.m_7220_(player.m_5446_());
                message.m_130946_(" VS " + " ".repeat(BossBaseReward.this.bossName.length()));
                message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.SUBTITLE, (Component)message, 0, 500, 0);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_subtitle_2", 160){

            @Override
            public void callback() {
                TextComponent message = new TextComponent("");
                message.m_7220_(player.m_5446_());
                message.m_130946_(" VS ");
                message.m_130946_(BossBaseReward.this.bossName);
                message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
                RewardsUtil.setNearPlayersTitle((Level)level, pos, 50, GuiTextLocation.SUBTITLE, (Component)message, 0, 100, 10);
            }
        });
        Scheduler.scheduleTask(new Task("boss_fight_start", 200){

            @Override
            public void callback() {
                BossBaseReward.this.startBossFight(level, pos, player, settings, battleWrapper);
            }
        });
    }

    public void startBossFight(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings, final BattleWrapper battleWrapper) {
        LivingEntity ent = this.initBoss(level, pos, player, settings, battleWrapper);
        ent.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ent.m_21051_(Attributes.f_22276_).m_22100_(this.getBossHealthDynamic(player, settings));
        ent.m_21153_(ent.m_21233_());
        level.m_7967_((Entity)ent);
        this.trackEntities(battleWrapper, new Entity[]{ent});
        this.trackPlayers(battleWrapper, player);
        Scheduler.scheduleTask(new Task("boss_fight_tracker", -1, 5){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                Entity ent;
                int i;
                for (i = battleWrapper.trackedEntities.size() - 1; i >= 0; --i) {
                    ent = battleWrapper.trackedEntities.get(i);
                    if (ent.m_6084_() || ent.f_19797_ <= 0 && !level.m_46791_().equals((Object)Difficulty.PEACEFUL)) continue;
                    battleWrapper.trackedEntities.remove(i);
                    if (!battleWrapper.trackedEntities.isEmpty()) continue;
                    BossBaseReward.this.endBossfight(true, level, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                }
                for (i = battleWrapper.trackedPlayers.size() - 1; i >= 0; --i) {
                    ent = (Entity)battleWrapper.trackedPlayers.get(i);
                    if (ent.m_20097_().m_123299_((double)battleWrapper.rewardCenterPos.m_123341_(), (double)battleWrapper.rewardCenterPos.m_123342_(), (double)battleWrapper.rewardCenterPos.m_123343_(), true) > 225.0 || ent.m_20186_() < (double)(battleWrapper.rewardCenterPos.m_123342_() - 1)) {
                        ent.m_6027_((double)battleWrapper.rewardCenterPos.m_123341_(), (double)(battleWrapper.rewardCenterPos.m_123342_() + 1), (double)battleWrapper.rewardCenterPos.m_123343_());
                    }
                    if (ent.m_6084_() || ent.f_19797_ <= 0 && !level.m_46791_().equals((Object)Difficulty.PEACEFUL)) continue;
                    for (Entity entity : battleWrapper.trackedEntities) {
                        entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                    battleWrapper.trackedEntities.clear();
                    BossBaseReward.this.endBossfight(false, level, pos, player, battleWrapper);
                    Scheduler.removeTask(this);
                    return;
                }
            }
        });
    }

    public void endBossfight(boolean resetPlayer, ServerLevel level, BlockPos pos, Player player, BattleWrapper battleWrapper) {
        for (Entity ent : battleWrapper.trackedSubEntities) {
            if (!ent.m_6084_()) continue;
            ent.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        battleWrapper.trackedSubEntities.clear();
        this.onBossFightEnd(level, pos, player);
        battleWrapper.domeGen.removeDome(resetPlayer);
    }

    protected void trackEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedEntities.addAll(Arrays.asList(ents));
    }

    protected void trackSubEntities(BattleWrapper battleWrapper, Entity ... ents) {
        battleWrapper.trackedSubEntities.addAll(Arrays.asList(ents));
    }

    protected void trackPlayers(BattleWrapper battleWrapper, Player ... player) {
        battleWrapper.trackedPlayers.addAll(Arrays.asList(player));
    }

    public abstract LivingEntity initBoss(ServerLevel var1, BlockPos var2, Player var3, JsonObject var4, BattleWrapper var5);

    public abstract void onBossFightEnd(ServerLevel var1, BlockPos var2, Player var3);

    public double getBossHealthDynamic(Player player, JsonObject settings) {
        double maxDamage = 3.0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Multimap atributes = stack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, stack);
            if (!atributes.containsKey((Object)Attributes.f_22281_)) continue;
            Collection damageList = atributes.get((Object)Attributes.f_22281_);
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.m_22218_())) continue;
                maxDamage = damage.m_22218_();
            }
        }
        double prePofileHealth = maxDamage * 15.0;
        double profileMult = super.getSettingAsDouble(settings, "bossHealthMultiplier", 1.0, 0.0, 10.0);
        return prePofileHealth * profileMult;
    }

    public ItemStack getHighestDamageItem(Player player) {
        double maxDamage = -1.0;
        ItemStack maxItem = ItemStack.f_41583_;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Multimap atributes = stack.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, stack);
            if (!atributes.containsKey((Object)Attributes.f_22281_)) continue;
            Collection damageList = atributes.get((Object)Attributes.f_22281_);
            for (AttributeModifier damage : damageList) {
                if (!(maxDamage < damage.m_22218_())) continue;
                maxDamage = damage.m_22218_();
                maxItem = stack;
            }
        }
        return maxItem;
    }

    protected static class BattleWrapper {
        public List<Entity> trackedEntities = new ArrayList<Entity>();
        public List<Entity> trackedSubEntities = new ArrayList<Entity>();
        public List<Player> trackedPlayers = new ArrayList<Player>();
        public BlockPos rewardCenterPos;
        public BioDomeGen domeGen;

        protected BattleWrapper() {
        }
    }
}

