/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BossBlazeReward
extends BossBaseReward {
    public BossBlazeReward() {
        super("demonic_blaze");
    }

    @Override
    public LivingEntity initBoss(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings, BossBaseReward.BattleWrapper battleWrapper) {
        final Blaze blaze = (Blaze)EntityType.f_20551_.m_20615_((Level)level);
        blaze.m_6593_((Component)new TextComponent("Demonic Blaze"));
        Scheduler.scheduleTask(new Task("blaze_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!blaze.m_6084_()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.goInvisible(blaze);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossBlazeReward.this.setGroundOnFire((Level)level, player.m_20097_());
                }
                if (RewardsUtil.rand.nextInt(3) == 4) {
                    BossBlazeReward.this.shootFireballs((Level)level, blaze, player);
                }
            }
        });
        return blaze;
    }

    private void goInvisible(Blaze blaze) {
        blaze.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5));
    }

    private void setGroundOnFire(Level level, BlockPos playerPos) {
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int zOff = -1; zOff <= 1; ++zOff) {
                BlockPos offPos = playerPos.m_142082_(xOff, 0, zOff);
                RewardsUtil.placeBlock(Blocks.f_50083_.m_49966_(), level, offPos);
            }
        }
    }

    private void shootFireballs(Level level, Blaze blaze, Player player) {
        double d1 = player.m_20185_() - blaze.m_20185_();
        double d2 = player.m_142469_().f_82289_ + (double)(player.m_20192_() / 2.0f) - (blaze.m_20186_() + (double)(blaze.m_20192_() / 2.0f));
        double d3 = player.m_20189_() - blaze.m_20189_();
        for (int i = 0; i < 5; ++i) {
            SmallFireball entitysmallfireball = new SmallFireball(level, (LivingEntity)blaze, d1 + RewardsUtil.rand.nextGaussian(), d2, d3 + RewardsUtil.rand.nextGaussian());
            entitysmallfireball.m_20097_().m_142022_(0.0, blaze.m_20186_() + (double)(blaze.m_20192_() / 2.0f) + 0.5, 0.0);
            level.m_7967_((Entity)entitysmallfireball);
        }
    }

    @Override
    public void onBossFightEnd(ServerLevel world, BlockPos pos, Player player) {
    }
}

