/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.parsers.RewardParser;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.registry.player.PlayerCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.StreamerReward;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.HTTPUtil;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;

public class CustomUserReward
extends BaseCustomReward {
    private final String userName;
    private final UUID uuid;
    private final String type;
    private final List<BasicReward> customRewards;

    public static void getCustomUserReward(UUID uuid) {
        JsonObject contentCreatorStuff;
        JsonElement userRewards;
        JsonElement users;
        if (!((Boolean)CCubesSettings.userSpecificRewards.get()).booleanValue()) {
            return;
        }
        try {
            users = HTTPUtil.makeAPIReq("GET", "chancecubes/userlist", new CustomEntry[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, "Chance Cubes failed to get the list of users with custom rewards!");
            return;
        }
        String userName = "";
        String type = "";
        String twitch = "";
        for (JsonElement userElem : users.getAsJsonArray()) {
            JsonObject user = userElem.getAsJsonObject();
            if (!user.get("UUID").getAsString().equalsIgnoreCase(uuid.toString())) continue;
            userName = user.get("Name").getAsString();
            type = user.get("Type").getAsString();
            if (!user.has("Twitch")) continue;
            twitch = user.get("Twitch").getAsString();
        }
        if (userName.equals("")) {
            CCubesCore.logger.log(org.apache.logging.log4j.Level.INFO, "No custom rewards detected for the current user!");
            return;
        }
        try {
            userRewards = HTTPUtil.makeAPIReq("GET", "chancecubes/user/" + userName, new CustomEntry[0]);
            contentCreatorStuff = HTTPUtil.makeAPIReq("GET", "chancecubes/contentcreatorinfo", new CustomEntry[0]).getAsJsonObject();
        }
        catch (Exception e) {
            CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, "Chance Cubes failed to get the custom list for " + userName + "!");
            CCubesCore.logger.log(org.apache.logging.log4j.Level.ERROR, e.getMessage());
            return;
        }
        if (userRewards.isJsonNull() || contentCreatorStuff.isJsonNull()) {
            return;
        }
        ArrayList<BasicReward> customRewards = new ArrayList<BasicReward>();
        for (Map.Entry reward : userRewards.getAsJsonObject().entrySet()) {
            customRewards.add(RewardParser.parseReward(reward).getKey());
        }
        String userNameFinal = userName;
        String typeFinal = type;
        String twitchFinal = twitch;
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        server.execute(() -> {
            GlobalCCRewardRegistry.DEFAULT.registerReward(new CustomUserReward(userNameFinal, uuid, typeFinal, customRewards));
            GlobalCCRewardRegistry.DEFAULT.getPlayerRewardRegistry(uuid.toString()).enableReward("chancecubes:cr_" + userNameFinal);
            ServerPlayer player = server.m_6846_().m_11259_(uuid);
            if (player == null) {
                return;
            }
            Style ccStyle = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_AQUA));
            if (contentCreatorStuff.get("Active").getAsBoolean() && !twitchFinal.trim().equals("")) {
                PlayerCCRewardRegistry.streamerReward.put(uuid, new StreamerReward(twitchFinal, contentCreatorStuff.getAsJsonArray("Options")));
            }
            if (contentCreatorStuff.get("Messages").getAsJsonArray().size() > 0) {
                for (JsonElement messageElem : contentCreatorStuff.get("Messages").getAsJsonArray()) {
                    String message = messageElem.getAsJsonObject().get("message").getAsString();
                    message = message.replace("%username%", userNameFinal);
                    RewardsUtil.sendMessageToPlayer((Player)player, (Component)new TextComponent(message).m_6270_(ccStyle));
                }
            } else {
                RewardsUtil.sendMessageToPlayer((Player)player, (Component)new TextComponent("Seems you have some custom Chance Cubes rewards " + userNameFinal + "....").m_6270_(ccStyle));
                RewardsUtil.sendMessageToPlayer((Player)player, (Component)new TextComponent("Let the fun begin! >:)").m_6270_(ccStyle));
            }
        });
    }

    public CustomUserReward(String un, UUID uuid, String type, List<BasicReward> rewards) {
        super("chancecubes:cr_" + un, 0);
        this.userName = un;
        this.uuid = uuid;
        this.type = type;
        this.customRewards = rewards;
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, final JsonObject settings) {
        if (!UsernameCache.getLastKnownUsername((UUID)this.uuid).equalsIgnoreCase(player.m_7755_().getString())) {
            RewardsUtil.sendMessageToPlayer(player, "Hey you aren't " + this.userName + "! You can't have their reward! Try again!");
            ItemEntity itemEnt = new ItemEntity((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)CCubesBlocks.CHANCE_CUBE, 1));
            level.m_7967_((Entity)itemEnt);
            return;
        }
        RewardsUtil.sendMessageToPlayer(player, "Selecting best (possibly deadly) reward for " + this.type + " " + this.userName);
        Scheduler.scheduleTask(new Task("Custom Reward", 100){

            @Override
            public void callback() {
                CustomUserReward.this.customRewards.get(RewardsUtil.rand.nextInt(CustomUserReward.this.customRewards.size())).trigger(level, pos, player, settings);
            }
        });
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

