/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class LootBoxReward
extends BaseCustomReward {
    private static final String COMMON_LORE = "{\"text\":\"Common\",\"color\":\"white\",\"bold\":true}";
    private static final String UNCOMMON_LORE = "{\"text\":\"Uncommon\",\"color\":\"green\",\"bold\":true}";
    private static final String RARE_LORE = "{\"text\":\"Rare\",\"color\":\"blue\",\"bold\":true}";
    private static final String LEGENDARY_LORE = "{\"text\":\"Legendary\",\"color\":\"red\",\"bold\":true}";
    private static final String EPIC_LORE = "{\"text\":\"Epic\",\"color\":\"dark_purple\",\"bold\":true}";
    private static final String SHINY_LORE = "{\"text\":\"SHINY!\",\"color\":\"aqua\",\"italic\":true}";
    public static final List<ItemStack> COMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> UNCOMMON = new ArrayList<ItemStack>();
    public static final List<ItemStack> RARE = new ArrayList<ItemStack>();
    public static final List<ItemStack> LEGENDARY = new ArrayList<ItemStack>();
    public static final List<ItemStack> EPIC = new ArrayList<ItemStack>();

    public LootBoxReward() {
        super("chancecubes:loot_box", 35);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, Player player, JsonObject settings) {
        level.m_46597_(pos, Blocks.f_50752_.m_49966_());
        Scheduler.scheduleTask(new Task("CC_Loot_Box_Animation", -1, 1){
            int tick;
            double y;
            double inc;
            {
                super(name, delay, updateTick);
                this.tick = 0;
                this.y = 0.0;
                this.inc = 0.023;
            }

            @Override
            public void callback() {
                BlockEntity te;
                RewardsUtil.sendMessageToNearPlayers((Level)level, pos, 25, "Open the Chance Cubes Loot Box to get some collectibles!");
                level.m_46597_(pos, Blocks.f_50087_.m_49966_());
                BlockEntity blockEntity = te = level.m_7702_(pos);
                if (!(blockEntity instanceof ChestBlockEntity)) {
                    return;
                }
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                for (int i = 0; i < 10; ++i) {
                    chest.m_6836_(i, LootBoxReward.this.getCollectible());
                }
            }

            @Override
            public void update() {
                if (this.tick < 250) {
                    this.y += this.inc;
                    if (this.y > 1.0 || this.y < 0.0) {
                        this.inc *= -1.0;
                    }
                    double xOff = Math.cos((float)this.tick / 3.0f);
                    double yOff = Math.sin((float)this.tick / 3.0f);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123800_, (double)pos.m_123341_() + xOff + 0.5, (double)pos.m_123342_() + this.y, (double)pos.m_123343_() + yOff + 0.5, 3.0, 0.0, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123800_, (double)pos.m_123341_() - xOff + 0.5, (double)pos.m_123342_() + this.y, (double)pos.m_123343_() - yOff + 0.5, 3.0, 0.0, 0.0);
                }
                if (this.tick == 250) {
                    for (int i = 0; i < 100; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.95, (double)pos.m_123343_() + 0.5, 3.0, 0.0, 0.0);
                    }
                }
                if (this.tick > 250) {
                    this.callback();
                    Scheduler.removeTask(this);
                }
                ++this.tick;
            }
        });
    }

    public ItemStack getCollectible() {
        int rarity = RewardsUtil.rand.nextInt(100);
        ItemStack stack = rarity < 50 ? COMMON.get(RewardsUtil.rand.nextInt(COMMON.size())).m_41777_() : (rarity < 80 ? UNCOMMON.get(RewardsUtil.rand.nextInt(UNCOMMON.size())).m_41777_() : (rarity < 93 ? RARE.get(RewardsUtil.rand.nextInt(RARE.size())).m_41777_() : (rarity < 99 ? LEGENDARY.get(RewardsUtil.rand.nextInt(LEGENDARY.size())).m_41777_() : EPIC.get(RewardsUtil.rand.nextInt(EPIC.size())).m_41777_())));
        if (RewardsUtil.rand.nextInt(100) == 42) {
            ListTag loreList;
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
                stack.m_41751_(nbt);
            }
            ListTag enchantList = new ListTag();
            nbt.m_128365_("Enchantments", (Tag)enchantList);
            enchantList.add((Object)new CompoundTag());
            CompoundTag display = (CompoundTag)nbt.m_128423_("display");
            if (display == null) {
                display = new CompoundTag();
                nbt.m_128365_("display", (Tag)display);
            }
            if ((loreList = (ListTag)display.m_128423_("Lore")) == null) {
                loreList = new ListTag();
                display.m_128365_("Lore", (Tag)loreList);
            }
            loreList.add((Object)StringTag.m_129297_((String)SHINY_LORE));
        }
        return stack;
    }

    private static ItemStack addItem(List<ItemStack> list, Item item, String lore) {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        stack.m_41751_(LootBoxReward.getLoreNBT(lore));
        list.add(stack);
        return stack;
    }

    public static CompoundTag getLoreNBT(String ... lore) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag display = new CompoundTag();
        nbt.m_128365_("display", (Tag)display);
        ListTag loreList = new ListTag();
        display.m_128365_("Lore", (Tag)loreList);
        for (String l : lore) {
            loreList.add((Object)StringTag.m_129297_((String)l));
        }
        return nbt;
    }

    static {
        LootBoxReward.addItem(COMMON, Items.f_42408_, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.f_42413_, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.f_42398_, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.f_42460_, COMMON_LORE);
        LootBoxReward.addItem(COMMON, Items.f_42402_, COMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42383_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42410_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42409_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42412_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42401_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42405_, UNCOMMON_LORE);
        LootBoxReward.addItem(UNCOMMON, Items.f_42500_, UNCOMMON_LORE);
        LootBoxReward.addItem(RARE, Items.f_42415_, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.f_42464_, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.f_42467_, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.f_42524_, RARE_LORE);
        LootBoxReward.addItem(RARE, Items.f_42749_, RARE_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.f_42354_, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.f_42482_, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.f_42473_, LEGENDARY_LORE);
        LootBoxReward.addItem(LEGENDARY, Items.f_42586_, LEGENDARY_LORE);
        LootBoxReward.addItem(EPIC, Items.f_42737_, EPIC_LORE);
        LootBoxReward.addItem(EPIC, Items.f_42461_, EPIC_LORE);
    }
}

