/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GameTurn;
import chanceCubes.util.Point;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class TicTacToeReward
extends BaseCustomReward {
    public TicTacToeReward() {
        super("chancecubes:tic_tac_toe", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        final int mistakeChance = super.getSettingAsInt(settings, "mistakeChance", 3, 0, 100);
        RewardsUtil.sendMessageToPlayer(player, "Lets play Tic-Tac-Toe!");
        RewardsUtil.sendMessageToPlayer(player, "Beat the Computer to get 500 Diamonds!");
        player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Blocks.f_50108_, 5)));
        final RewardBlockCache cache = new RewardBlockCache((Level)level, pos, player.m_20097_());
        for (int x = -2; x < 3; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 5; ++y) {
                    cache.cacheBlock(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                }
            }
        }
        level.m_46597_(pos.m_142082_(-1, 0, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-1, 1, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-1, 2, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-1, 3, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-1, 4, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(1, 0, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(1, 1, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(1, 2, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(1, 3, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(1, 4, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-2, 1, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(0, 1, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(2, 1, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(-2, 3, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(0, 3, 0), Blocks.f_50752_.m_49966_());
        level.m_46597_(pos.m_142082_(2, 3, 0), Blocks.f_50752_.m_49966_());
        Scheduler.scheduleTask(new Task("Tic_Tac_Toe_Game", 6000, 5){
            final Board board;
            {
                super(name, delay, updateTick);
                this.board = new Board();
            }

            @Override
            public void callback() {
                cache.restoreBlocks((Entity)player);
            }

            @Override
            public void update() {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        if (this.board.board[x + 1][y + 1] != 0 || level.m_8055_(pos.m_142082_(x * 2, y * 2 + 2, 0)).m_60795_()) continue;
                        this.makeMove(x + 1, y + 1);
                    }
                }
            }

            private void makeMove(int x, int y) {
                this.board.placeMove(x, y, GameTurn.PLAYER);
                if (!this.board.isGameOver()) {
                    this.board.minimax(0, GameTurn.CPU, mistakeChance);
                    this.board.placeMove(this.board.computersMove.x, this.board.computersMove.y, GameTurn.CPU);
                    level.m_46597_(pos.m_142082_(this.board.computersMove.x * 2 - 2, this.board.computersMove.y * 2, 0), Blocks.f_50105_.m_49966_());
                }
                if (this.board.isGameOver()) {
                    if (this.board.hasCPUWon()) {
                        RewardsUtil.sendMessageToPlayer(player, "The Computer won! Better luck next time!");
                    } else if (this.board.hasPlayerWon()) {
                        RewardsUtil.sendMessageToPlayer(player, "You Won? You must have cheated... You only get 5 diamonds!");
                        player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42415_, 5)));
                    } else {
                        RewardsUtil.sendMessageToPlayer(player, "You tied! Better luck next time!");
                    }
                    final 1 superTask = this;
                    Scheduler.scheduleTask(new Task("Tic_Tac_Toe_Game_End_Delay", 40){

                        @Override
                        public void callback() {
                            superTask.delayLeft = 0;
                        }
                    });
                }
            }
        });
    }

    private static class Board {
        public int[][] board = new int[3][3];
        public Point computersMove;

        private Board() {
        }

        public boolean isGameOver() {
            return this.hasPlayerWon() || this.hasCPUWon() || this.getAvailableStates().isEmpty();
        }

        public boolean hasCPUWon() {
            if (this.board[0][0] == this.board[1][1] && this.board[0][0] == this.board[2][2] && this.board[0][0] == 1 || this.board[0][2] == this.board[1][1] && this.board[0][2] == this.board[2][0] && this.board[0][2] == 1) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if ((this.board[i][0] != this.board[i][1] || this.board[i][0] != this.board[i][2] || this.board[i][0] != 1) && (this.board[0][i] != this.board[1][i] || this.board[0][i] != this.board[2][i] || this.board[0][i] != 1)) continue;
                return true;
            }
            return false;
        }

        public boolean hasPlayerWon() {
            if (this.board[0][0] == this.board[1][1] && this.board[0][0] == this.board[2][2] && this.board[0][0] == 2 || this.board[0][2] == this.board[1][1] && this.board[0][2] == this.board[2][0] && this.board[0][2] == 2) {
                return true;
            }
            for (int i = 0; i < 3; ++i) {
                if ((this.board[i][0] != this.board[i][1] || this.board[i][0] != this.board[i][2] || this.board[i][0] != 2) && (this.board[0][i] != this.board[1][i] || this.board[0][i] != this.board[2][i] || this.board[0][i] != 2)) continue;
                return true;
            }
            return false;
        }

        public List<Point> getAvailableStates() {
            ArrayList<Point> availablePoints = new ArrayList<Point>();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.board[i][j] != 0) continue;
                    availablePoints.add(new Point(i, j));
                }
            }
            return availablePoints;
        }

        public void placeMove(int x, int y, GameTurn turn) {
            this.board[x][y] = turn == GameTurn.PLAYER ? 2 : 1;
        }

        public int minimax(int depth, GameTurn turn, int mistakeChance) {
            if (this.hasCPUWon()) {
                return 1;
            }
            if (this.hasPlayerWon()) {
                return -1;
            }
            List<Point> pointsAvailable = this.getAvailableStates();
            if (pointsAvailable.isEmpty()) {
                return 0;
            }
            if (depth == 0 && RewardsUtil.rand.nextInt(100) < mistakeChance) {
                this.computersMove = pointsAvailable.get(RewardsUtil.rand.nextInt(pointsAvailable.size()));
                return 0;
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < pointsAvailable.size(); ++i) {
                int currentScore;
                Point point = pointsAvailable.get(i);
                this.placeMove(point.x, point.y, turn);
                if (turn == GameTurn.CPU) {
                    currentScore = this.minimax(depth + 1, GameTurn.PLAYER, mistakeChance);
                    max = Math.max(currentScore, max);
                    if (currentScore >= 0 && depth == 0) {
                        this.computersMove = point;
                    }
                    if (currentScore == 1) {
                        this.board[point.x][point.y] = 0;
                        break;
                    }
                    if (i == pointsAvailable.size() - 1 && max < 0 && depth == 0) {
                        this.computersMove = point;
                    }
                } else if (turn == GameTurn.PLAYER && (min = Math.min(currentScore = this.minimax(depth + 1, GameTurn.CPU, mistakeChance), min)) == -1) {
                    this.board[point.x][point.y] = 0;
                    break;
                }
                this.board[point.x][point.y] = 0;
            }
            return turn == GameTurn.CPU ? max : min;
        }
    }
}

