/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.sounds;

import chanceCubes.CCubesCore;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="chancecubes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCubesSounds {
    public static SoundEvent D20_BREAK;
    public static SoundEvent GIANT_CUBE_SPAWN;
    public static Map<String, SoundEvent> customSounds;
    private static boolean registered;

    @SubscribeEvent
    public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> e) {
        ResourceLocation res = new ResourceLocation("chancecubes", "d20_break");
        D20_BREAK = (SoundEvent)new SoundEvent(res).setRegistryName(res);
        res = new ResourceLocation("chancecubes", "giant_cube_spawn");
        GIANT_CUBE_SPAWN = (SoundEvent)new SoundEvent(res).setRegistryName(res);
        e.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{D20_BREAK, GIANT_CUBE_SPAWN});
        registered = true;
    }

    public static SoundEvent registerSound(String soundID) {
        SoundEvent sound;
        if (!customSounds.containsKey(soundID)) {
            if (registered) {
                CCubesCore.logger.log(Level.WARN, "A new sound was added after the sounds were registered and therefore the new sound could not be added!");
            }
            ResourceLocation res = new ResourceLocation("minecraft", soundID);
            sound = (SoundEvent)new SoundEvent(res).setRegistryName(res);
            customSounds.put(soundID, sound);
        } else {
            sound = customSounds.get(soundID);
        }
        return sound;
    }

    static {
        customSounds = new HashMap<String, SoundEvent>();
        registered = false;
    }
}

