/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.sounds.CCubesSounds;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileChanceD20
extends BlockEntity {
    public static final ModelProperty<D20AnimationWrapper> D20AnimationProperty = new ModelProperty();
    private static final Random random = new Random();
    private boolean breaking = false;
    private int stage = 0;
    public float rotation = 0.0f;
    public float wave = 0.0f;
    private Player player;
    private int chance;
    private boolean isScanned = false;
    private final D20AnimationWrapper animationWrapper = new D20AnimationWrapper();

    public TileChanceD20(BlockPos pos, BlockState state) {
        super(CCubesBlocks.TILE_CHANCE_ICOSAHEDRON, pos, state);
        if (!((Boolean)CCubesSettings.d20UseNormalChances.get()).booleanValue()) {
            this.chance = random.nextBoolean() ? -100 : 100;
        } else {
            this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            while (this.chance > 100 || this.chance < -100) {
                this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            }
        }
    }

    public TileChanceD20(int initialChance, BlockPos pos, BlockState state) {
        super(CCubesBlocks.TILE_CHANCE_ICOSAHEDRON, pos, state);
        this.chance = initialChance;
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        nbt.m_128405_("chance", this.getChance());
        nbt = super.m_6945_(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.chance = nbt.m_128451_("chance");
    }

    public void tick() {
        if (this.breaking) {
            ++this.stage;
        }
        if (this.stage > 200) {
            this.breaking = false;
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
                this.f_58857_.m_46747_(this.m_58899_());
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward((ServerLevel)this.f_58857_, this.m_58899_(), this.player, this.getChance());
            }
        } else if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            Quaternion yaw = new Quaternion(0.0f, 1.0f, 0.0f, (float)(Math.toRadians((float)this.f_58857_.m_46467_() % 10000.0f / 10000.0f * 360.0f) + (0.4 + Math.pow(1.02, this.getStage() + 1))));
            Quaternion pitch = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
            this.animationWrapper.transform = new Vector3f(0.5f, 0.5f + this.wave * 0.15f, 0.5f);
            this.animationWrapper.rot = yaw;
            this.f_58857_.m_46597_(this.m_58899_(), this.m_58900_());
        }
    }

    public void startBreaking(Player player) {
        if (!this.breaking) {
            if (!player.f_19853_.m_5776_()) {
                player.f_19853_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), CCubesSounds.D20_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.player = player;
            }
            this.breaking = true;
            this.stage = 0;
        }
    }

    public int getStage() {
        return this.stage;
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag syncData = new CompoundTag();
        syncData = this.m_6945_(syncData);
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 1, syncData);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }

    @Nonnull
    public IModelData getModelData() {
        IModelData modelData = super.getModelData();
        return modelData;
    }

    public static class D20AnimationWrapper {
        public Vector3f transform;
        public Quaternion rot;
    }
}

