/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;

public abstract class Task {
    public String name;
    public int delayLeft;
    private boolean forever = false;
    public int updateTick;

    public Task(String name, int delay) {
        this(name, delay, -1);
    }

    public Task(String name, int delay, int updateTick) {
        this.name = name;
        this.delayLeft = delay;
        if (delay == -1) {
            this.forever = true;
        }
        this.updateTick = updateTick;
    }

    public boolean shouldUpdate() {
        return this.updateTick != -1 && this.delayLeft % this.updateTick == 0;
    }

    public abstract void callback();

    public boolean tickTask() {
        --this.delayLeft;
        return this.delayLeft <= 0 && !this.forever;
    }

    public void update() {
    }

    public void showTimeLeft(Player player, GuiTextLocation location) {
        int time = this.delayLeft / 20;
        TextComponent message = new TextComponent(String.valueOf(time));
        message.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
        RewardsUtil.setPlayerTitle(player, location, (Component)message, 0, 20, 0);
    }
}

