/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.mcwrapper.EntityWrapper;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class JarGuessReward
extends BaseCustomReward {
    private final Map<Player, PlayerGuessing> inGuess = new HashMap<Player, PlayerGuessing>();

    public JarGuessReward() {
        super("chancecubes:jar_guess", 25);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
        if (this.inGuess.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        int amount = RewardsUtil.rand.nextInt(50) + 60;
        RewardBlockCache blockCache = new RewardBlockCache((Level)level, pos, player.m_20097_());
        for (int x = -3; x < 4; ++x) {
            for (int z = -3; z < 4; ++z) {
                for (int y = 0; y < 7; ++y) {
                    if (x == -3 || x == 3 || z == -3 || z == 3 || y == 0 || y == 6) {
                        blockCache.cacheBlock(new BlockPos(x, y, z), Blocks.f_50058_.m_49966_());
                        continue;
                    }
                    blockCache.cacheBlock(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                }
            }
        }
        PlayerGuessing guessing = new PlayerGuessing(amount, blockCache);
        int batsSpawned = 0;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y < 5; ++y) {
                    for (int i = 0; i < 4; ++i) {
                        if (batsSpawned >= amount) continue;
                        BlockPos pos2 = pos.m_7637_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                        Bat bat = (Bat)EntityWrapper.spawnEntityAt(EntityType.f_20549_, (Level)level, pos2);
                        guessing.bats.add(bat);
                        ++batsSpawned;
                    }
                }
            }
        }
        RewardsUtil.sendMessageToPlayer(player, "How many bats are in UrjnaswX Jar?");
        RewardsUtil.sendMessageToPlayer(player, "You have 30 seconds to answer!");
        RewardsUtil.sendMessageToPlayer(player, "Guess right and you get 20 Emeralds!");
        RewardsUtil.sendMessageToPlayer(player, "But you lose 1 emerald per bat you are off!");
        this.inGuess.put(player, guessing);
        Scheduler.scheduleTask(new Task("Jar Guess", 600, 20){

            @Override
            public void callback() {
                JarGuessReward.this.timeUp(player, -1);
            }

            @Override
            public void update() {
                if (!JarGuessReward.this.inGuess.containsKey(player)) {
                    Scheduler.removeTask(this);
                }
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
                }
            }
        });
    }

    private void timeUp(Player player, int guessed) {
        if (!this.inGuess.containsKey(player)) {
            return;
        }
        int answer = this.inGuess.get((Object)player).answer;
        if (guessed != -1) {
            RewardsUtil.sendMessageToPlayer(player, "The Correct answer was " + answer);
            RewardsUtil.sendMessageToPlayer(player, "You were off by " + Math.abs(answer - guessed));
            int winAmount = Math.max(0, 20 - Math.abs(answer - guessed));
            RewardsUtil.sendMessageToPlayer(player, "You won " + winAmount + " Emeralds!");
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42616_, winAmount));
        } else {
            RewardsUtil.sendMessageToPlayer(player, "Times up! The answer was " + answer);
        }
        for (Bat bat : this.inGuess.get((Object)player).bats) {
            bat.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.inGuess.get((Object)player).blockCache.restoreBlocks((Entity)player);
        this.inGuess.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent.Submitted event) {
        ServerPlayer player = event.getPlayer();
        if (this.inGuess.containsKey(player)) {
            String answer = event.getRawText();
            if (answer.matches("\\d+")) {
                this.timeUp((Player)player, Integer.parseInt(answer));
                event.setCanceled(true);
            } else {
                RewardsUtil.sendMessageToPlayer((Player)player, answer + " is not a accepted number!");
            }
        }
    }

    private static class PlayerGuessing {
        public final int answer;
        public final RewardBlockCache blockCache;
        public final List<Bat> bats = new ArrayList<Bat>();

        public PlayerGuessing(int answer, RewardBlockCache blockCache) {
            this.answer = answer;
            this.blockCache = blockCache;
        }
    }
}

