/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.tileentities.TileGiantCube;
import chanceCubes.util.RewardsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GiantCubeUtil {
    public static boolean checkMultiBlockForm(BlockPos pos, Level level, boolean build) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return false;
        }
        BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, level);
        int cx = bottomLeft.m_123341_();
        int cy = bottomLeft.m_123342_();
        int cz = bottomLeft.m_123343_();
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int y = cy; y < cy + 3; ++y) {
                for (int z = cz; z < cz + 3; ++z) {
                    if (!level.m_8055_(new BlockPos(x, y, z)).m_60734_().equals(CCubesBlocks.CHANCE_CUBE.get())) continue;
                    ++i;
                }
            }
        }
        if (build) {
            if (i > 26) {
                GiantCubeUtil.setupStructure(new BlockPos(cx, cy, cz), level, true);
                return true;
            }
            return false;
        }
        return i > 26;
    }

    public static void setupStructure(BlockPos pos, Level level, boolean areCoordsCorrect) {
        if (((Boolean)CCubesSettings.disableGiantCC.get()).booleanValue()) {
            return;
        }
        int cx = pos.m_123341_();
        int cy = pos.m_123342_();
        int cz = pos.m_123343_();
        if (!areCoordsCorrect) {
            BlockPos bottomLeft = GiantCubeUtil.findBottomCorner(pos, level);
            cx = bottomLeft.m_123341_();
            cy = bottomLeft.m_123342_();
            cz = bottomLeft.m_123343_();
        }
        int i = 0;
        for (int x = cx; x < cx + 3; ++x) {
            for (int z = cz; z < cz + 3; ++z) {
                for (int y = cy; y < cy + 3; ++y) {
                    boolean master;
                    RewardsUtil.placeBlock(((BaseChanceBlock)((Object)CCubesBlocks.GIANT_CUBE.get())).m_49966_(), level, new BlockPos(x, y, z), ++i == 27 ? 3 : 2, level.m_8055_(new BlockPos(x, y, z)).m_60734_().equals(CCubesBlocks.CHANCE_CUBE.get()));
                    BlockEntity tile = level.m_7702_(new BlockPos(x, y, z));
                    boolean bl = master = x == cx + 1 && y == cy + 1 && z == cz + 1;
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).setMasterCoords(cx + 1, cy + 1, cz + 1);
                    ((TileGiantCube)tile).setHasMaster(true);
                    ((TileGiantCube)tile).setIsMaster(master);
                }
            }
        }
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)CCubesSounds.GIANT_CUBE_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static BlockPos findBottomCorner(BlockPos pos, Level level) {
        int cx = pos.m_123341_();
        int cy = pos.m_123342_();
        int cz = pos.m_123343_();
        while (level.m_8055_(pos.m_7918_(0, -1, 0)).m_60734_().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.m_7918_(0, -1, 0);
            --cy;
        }
        while (level.m_8055_(pos.m_7918_(-1, 0, 0)).m_60734_().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.m_7918_(-1, 0, 0);
            --cx;
        }
        while (level.m_8055_(pos.m_7918_(0, 0, -1)).m_60734_().equals(CCubesBlocks.CHANCE_CUBE.get())) {
            pos = pos.m_7918_(0, 0, -1);
            --cz;
        }
        return new BlockPos(cx, cy, cz);
    }

    public static void resetStructure(BlockPos pos, Level level) {
        for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
            for (int y = pos.m_123342_() - 1; y < pos.m_123342_() + 2; ++y) {
                for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockEntity tile = level.m_7702_(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    level.m_46747_(blockPos);
                    level.m_46597_(blockPos, ((BaseChanceBlock)((Object)CCubesBlocks.CHANCE_CUBE.get())).m_49966_());
                }
            }
        }
    }

    public static void removeStructure(BlockPos pos, Level level) {
        for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
            for (int y = pos.m_123342_() - 1; y < pos.m_123342_() + 2; ++y) {
                for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 2; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    BlockEntity tile = level.m_7702_(blockPos);
                    if (!(tile instanceof TileGiantCube)) continue;
                    ((TileGiantCube)tile).reset();
                    level.m_46747_(blockPos);
                    level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }
}

