/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.commands.CCubesRewardArguments;
import chanceCubes.commands.CCubesServerCommands;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.items.CCubesItems;
import chanceCubes.listeners.PlayerConnectListener;
import chanceCubes.listeners.TickListener;
import chanceCubes.listeners.WorldGen;
import chanceCubes.modifier.CCubesModifiers;
import chanceCubes.network.CCubesPacketHandler;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.sounds.CCubesSounds;
import chanceCubes.util.NonreplaceableBlockOverride;
import chanceCubes.util.StatsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="chancecubes")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static final Logger logger = LogManager.getLogger((String)"chancecubes");

    public CCubesCore() {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certificate, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certificate, String str) {
                }
            }};
            context.init(null, trustManager, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CCubesBlocks.BLOCKS.register(eventBus);
        CCubesBlocks.BLOCK_ENTITIES.register(eventBus);
        CCubesItems.ITEMS.register(eventBus);
        CCubesSounds.SOUNDS.register(eventBus);
        CCubesModifiers.BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        CCubesRewardArguments.COMMAND_ARGUMENT_TYPES.register(eventBus);
        WorldGen.FEATURES.register(eventBus);
        eventBus.addListener(this::commonStart);
        eventBus.addListener(this::registerCreativeTabs);
        eventBus.addListener(this::onIMCMessage);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.addListener(ClientHelper::clientStart);
            eventBus.addListener(ClientHelper::onEntityRenders);
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigLoader.initParentFolder();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigLoader.configSpec, MODID + File.separatorChar + "chancecubes-server.toml");
    }

    public void commonStart(FMLCommonSetupEvent event) {
        CCubesPacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectListener());
        MinecraftForge.EVENT_BUS.register((Object)new TickListener());
        event.enqueueWork(StatsRegistry::init);
    }

    public void registerCreativeTabs(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(new ResourceLocation(MODID, "blocks"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)CCubesBlocks.CHANCE_CUBE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.chancecubes")).m_257501_((parameters, output) -> {
            List<ItemStack> stacks = CCubesItems.ITEMS.getEntries().stream().filter(registryObject -> registryObject.get() != ((BaseChanceBlock)((Object)((Object)((Object)((Object)CCubesBlocks.GIANT_CUBE.get()))))).m_5456_()).map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            output.m_246601_(stacks);
        }));
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        if (((Boolean)CCubesSettings.chestLoot.get()).booleanValue() && event.getName().m_135815_().contains("chests")) {
            event.getTable().addPool(LootPool.m_79043_().name("chance_cubes_cubes").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CCubesItems.CHANCE_CUBE.get()))).m_79082_());
        }
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent event) {
        CCubesSettings.backupNRB.add(Blocks.f_50752_.m_49966_());
        CCubesSettings.backupNRB.add(Blocks.f_50080_.m_49966_());
        DefaultRewards.loadDefaultRewards();
        DefaultGiantRewards.loadDefaultRewards();
        CustomRewardsLoader.instance.loadCustomRewards();
        NonreplaceableBlockOverride.loadOverrides();
        logger.log(Level.INFO, "Death and destruction prepared! (And Cookies. Cookies were also prepared.)");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new CCubesServerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void onIMCMessage(InterModProcessEvent e) {
        e.getIMCStream().forEach(message -> {
            Object obj;
            Logger logger = LogManager.getLogger((String)MODID);
            if (message.method().equalsIgnoreCase("add-nonreplaceable") && (obj = message.messageSupplier().get()) instanceof BlockState) {
                BlockState state = (BlockState)obj;
                CCubesSettings.nonReplaceableBlocksIMC.add(state);
                logger.info(message.senderModId() + " has added the blockstate of \"" + state + "\" that Chance Cubes rewards will no longer replace.");
            }
        });
    }
}

