/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.datagen;

import chanceCubes.datagen.CCubesBiomeModifiers;
import chanceCubes.datagen.CCubesBlockTagProvider;
import chanceCubes.datagen.CCubesDamageTypeProvider;
import chanceCubes.datagen.CCubesDamageTypeTagProvider;
import chanceCubes.datagen.CCubesItemTagProvider;
import chanceCubes.datagen.CCubesRecipeProvider;
import chanceCubes.listeners.WorldGen;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCubesDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(CCubesDatagen::getProvider);
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesRecipeProvider(packOutput));
        CCubesBlockTagProvider blockTagsProvider = new CCubesBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)blockTagsProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, Set.of("chancecubes")));
        generator.addProvider(event.includeServer(), (DataProvider)new CCubesDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_268580_, CCubesDamageTypeProvider::bootstrap);
        registryBuilder.m_254916_(Registries.f_256911_, WorldGen::configuredBootstrap);
        registryBuilder.m_254916_(Registries.f_256988_, WorldGen::placedBootstrap);
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, CCubesBiomeModifiers::bootstrap);
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }
}

