/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.blocks.BlockFallingCustom;
import chanceCubes.config.CCubesSettings;
import chanceCubes.rewards.defaultRewards.BossBaseReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BossRavagerReward
extends BossBaseReward {
    private ArmorStand armorStandEntity;

    public BossRavagerReward() {
        super("ravager");
    }

    @Override
    public LivingEntity initBoss(final ServerLevel level, BlockPos pos, final Player player, JsonObject settings, BossBaseReward.BattleWrapper battleWrapper) {
        final Ravager ravager = (Ravager)EntityType.f_20518_.m_20615_((Level)level);
        this.armorStandEntity = (ArmorStand)EntityType.f_20529_.m_20615_((Level)level);
        this.armorStandEntity.m_20331_(true);
        this.armorStandEntity.m_7998_((Entity)ravager, true);
        level.m_7967_((Entity)this.armorStandEntity);
        ItemStack headStack = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag nbt = headStack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            headStack.m_41751_(nbt);
        }
        nbt.m_128359_("SkullOwner", player.m_7755_().getString());
        this.armorStandEntity.m_8061_(EquipmentSlot.HEAD, headStack);
        this.armorStandEntity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42473_));
        this.armorStandEntity.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42474_));
        this.armorStandEntity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42392_));
        this.armorStandEntity.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        Scheduler.scheduleTask(new Task("witch_abilities", -1, 20){

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                if (!ravager.m_6084_()) {
                    Scheduler.removeTask(this);
                    return;
                }
                if (RewardsUtil.rand.nextInt(20) == 4) {
                    BossRavagerReward.this.groundPound(ravager.m_20097_(), level);
                }
                if (RewardsUtil.rand.nextInt(10) == 4) {
                    BossRavagerReward.this.charge(ravager, player);
                }
            }
        });
        return ravager;
    }

    private void groundPound(final BlockPos ravagerPos, final ServerLevel level) {
        Scheduler.scheduleTask(new Task("ground_pound_ability", -1, 5){
            int radius;
            {
                super(name, delay, updateTick);
                this.radius = 3;
            }

            @Override
            public void callback() {
            }

            @Override
            public void update() {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        pos.m_122178_(x, 0, z);
                        if (!BossRavagerReward.this.withinDistance((BlockPos)pos, this.radius)) continue;
                        BlockPos newPos = ravagerPos.m_121955_((Vec3i)pos);
                        BlockState state = level.m_8055_(newPos);
                        if (CCubesSettings.nonReplaceableBlocks.contains(state) || state.m_60734_().equals(Blocks.f_50016_)) {
                            state = Blocks.f_50493_.m_49966_();
                        } else {
                            level.m_46597_(newPos, Blocks.f_50016_.m_49966_());
                        }
                        BlockFallingCustom block = new BlockFallingCustom((Level)level, (double)newPos.m_123341_() + 0.5, newPos.m_123342_(), (double)newPos.m_123343_() + 0.5, state, newPos.m_123342_(), new OffsetBlock(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_(), state, false));
                        block.f_19789_ = 0.0f;
                        block.m_20334_(0.0, 0.33f, 0.0);
                        level.m_7967_((Entity)block);
                    }
                }
                ++this.radius;
                if (this.radius == 9) {
                    Scheduler.removeTask(this);
                }
            }
        });
    }

    private void charge(Ravager ravager, Player player) {
        BlockPos dist = player.m_20097_().m_121996_((Vec3i)ravager.m_20097_());
        double unit = Math.sqrt(dist.m_123331_((Vec3i)BlockPos.f_121853_));
        BlockPos move = BlockPos.m_274561_((double)((double)dist.m_123341_() / unit * 3.0), (double)0.0, (double)((double)dist.m_123343_() / unit * 3.0));
        ravager.m_20334_((double)move.m_123341_(), 0.0, (double)move.m_123343_());
    }

    @Override
    public void onBossFightEnd(ServerLevel level, BlockPos pos, Player player) {
        this.armorStandEntity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean withinDistance(BlockPos pos, double rad) {
        double dist = pos.m_203202_(0.0, 0.0, 0.0);
        return dist < rad * rad && dist >= (rad - 1.0) * (rad - 1.0);
    }
}

