/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.items;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.items.CCubesItems;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.tileentities.TileChanceD20;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemChanceCube
extends BlockItem {
    public ItemChanceCube(BaseChanceBlock b) {
        super((Block)b, ItemChanceCube.getProps(b));
        this.setRegistryName(b.getRegistryName());
    }

    public static Item.Properties getProps(Block b) {
        Item.Properties props = new Item.Properties();
        if (!b.equals((Object)CCubesBlocks.GIANT_CUBE)) {
            props.m_41491_(CCubesCore.modTab);
        }
        return props;
    }

    public void setChance(ItemStack stack, int chance) {
        CompoundTag nbt;
        if (chance > 100 || chance < -101) {
            chance = -101;
        }
        if ((nbt = stack.m_41783_()) == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("Chance", chance);
        stack.m_41751_(nbt);
    }

    public int getChance(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return -101;
        }
        return stack.m_41783_().m_128441_("Chance") ? stack.m_41783_().m_128451_("Chance") : -101;
    }

    public String getChanceAsStringValue(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return "Random";
        }
        return stack.m_41783_().m_128441_("Chance") ? (stack.m_41783_().m_128451_("Chance") == -101 ? "Random" : "" + stack.m_41783_().m_128451_("Chance")) : "Random";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Item item = stack.m_41720_();
        if (!item.equals((Object)CCubesItems.CUBE_DISPENSER)) {
            String chance = this.getChanceAsStringValue(stack);
            list.add((Component)new TextComponent("Chance Value: " + chance));
        }
        if (item.equals((Object)CCubesItems.COMPACT_GIANT_CUBE)) {
            list.add((Component)new TextComponent(ChatFormatting.RED + "WARNING: The Giant Chance Cube will probably cause lots damage and/or place a lot of blocks down... You've been warned."));
        } else if (item.equals((Object)CCubesItems.CHANCE_CUBE)) {
            list.add((Component)new TextComponent(ChatFormatting.RED + "Warning: It is recommended you don't open these in or next to your base."));
        } else if (item.equals((Object)CCubesItems.CHANCE_ICOSAHEDRON)) {
            list.add((Component)new TextComponent(ChatFormatting.RED + "WORK IN PROGRESS"));
        }
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        int chance;
        boolean placed = super.m_7429_(context, state);
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        if (te != null && (chance = this.getChance(context.m_43722_())) != -101) {
            if (te instanceof TileChanceCube) {
                ((TileChanceCube)te).setChance(chance);
            } else if (te instanceof TileChanceD20) {
                ((TileChanceD20)te).setChance(chance);
            }
        }
        return placed;
    }
}

