/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BeaconArenaReward
extends BaseCustomReward {
    private final BlockState[] whitelist = new BlockState[]{Blocks.f_50080_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50069_.m_49966_(), Blocks.f_50186_.m_49966_(), Blocks.f_50078_.m_49966_(), Blocks.f_50129_.m_49966_(), RewardsUtil.getRandomWool(), Blocks.f_50076_.m_49966_(), Blocks.f_50033_.m_49966_(), Blocks.f_50141_.m_49966_(), Blocks.f_50134_.m_49966_()};

    public BeaconArenaReward() {
        super("chancecubes:beacon_arena", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.spawnWall(blocks);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, 17), Blocks.f_50074_);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, 17), Blocks.f_50090_);
        this.spawnSmallBeacon(blocks, new BlockPos(-17, 0, -17), Blocks.f_50268_);
        this.spawnSmallBeacon(blocks, new BlockPos(17, 0, -17), Blocks.f_50075_);
        this.spawnBigBeacon(blocks);
        this.editFloor(blocks);
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
        }
    }

    public void spawnSmallBeacon(List<OffsetBlock> blocks, BlockPos at, Block b) {
        int delay = 0;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                blocks.add(new OffsetBlock(at.m_123341_() + x, at.m_123342_(), at.m_123343_() + z, b, false, delay));
                ++delay;
            }
        }
        blocks.add(new OffsetBlock(at.m_123341_(), at.m_123342_() + 1, at.m_123343_(), Blocks.f_50273_, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnBigBeacon(List<OffsetBlock> blocks) {
        int delay = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    if (y == 1 && (x <= -2 || x >= 2 || z <= -2 || z >= 2)) continue;
                    blocks.add(new OffsetBlock(x, y, z, Blocks.f_50075_, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(0, 2, 0, Blocks.f_50273_, false, delay).setCausesBlockUpdate(true));
    }

    public void spawnWall(List<OffsetBlock> blocks) {
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int degree = 0; degree < 360; ++degree) {
            int z;
            double arcVal = Math.toRadians(degree);
            int x = (int)(28.0 * Math.cos(arcVal));
            BlockPos temp = new BlockPos(x, 0, z = (int)(28.0 * Math.sin(arcVal)));
            if (usedPositions.contains(temp)) continue;
            usedPositions.add(temp);
        }
        int delay = 0;
        for (BlockPos pos : usedPositions) {
            blocks.add(new OffsetBlock(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), Blocks.f_50058_, false, delay));
            blocks.add(new OffsetBlock(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_(), Blocks.f_50058_, false, delay + 1));
            blocks.add(new OffsetBlock(pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_(), Blocks.f_50058_, false, delay + 2));
            ++delay;
        }
    }

    public void editFloor(List<OffsetBlock> blocks) {
        int delay = 0;
        ArrayList<BlockPos> usedPositions = new ArrayList<BlockPos>();
        for (int radius = 0; radius < 28; ++radius) {
            for (int degree = 0; degree < 360; ++degree) {
                int z;
                double arcVal = Math.toRadians(degree);
                int x = (int)((double)radius * Math.cos(arcVal));
                BlockPos temp = new BlockPos(x, 0, z = (int)((double)radius * Math.sin(arcVal)));
                if (usedPositions.contains(temp)) continue;
                usedPositions.add(temp);
            }
        }
        for (BlockPos pos : usedPositions) {
            BlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(pos.m_123341_(), -1, pos.m_123343_(), state, false, delay / 8));
            ++delay;
        }
    }
}

