/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldstrader.items;

import com.coldspell.coldstrader.init.ModSounds;
import com.coldspell.coldstrader.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TradersMirror
extends Item {
    public TradersMirror() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200918_c(20).func_234689_a_());
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("\u00a73Wandering Traders use these mirrors when they get lost underground."));
        tooltip.add((ITextComponent)new StringTextComponent("\u00a7bCrouch + Right Click to teleport to the Surface"));
        tooltip.add((ITextComponent)new StringTextComponent("\u00a76Repair Material: Lapis Lazuli"));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184614_ca();
        if (TradersMirror.isUsable(stack)) {
            this.teleport(worldIn, playerIn, stack);
        } else {
            playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
            this.spark(playerIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_196128_bn;
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.func_77952_i() <= stack.func_77958_k() - 1;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.textureCheck(worldIn, stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void textureCheck(World worldIn, ItemStack stack) {
        ItemModelsProperties.func_239418_a_((Item)stack.func_77973_b(), (ResourceLocation)new ResourceLocation("model"), (IItemPropertyGetter)new IItemPropertyGetter(){

            public float call(ItemStack p_call_1_, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
                float texture = 0.0f;
                if (!TradersMirror.isUsable(p_call_1_)) {
                    texture = 1.0f;
                }
                return texture;
            }
        });
    }

    public void teleport(World worldIn, PlayerEntity playerIn, ItemStack itemstack) {
        if (playerIn.func_213453_ef()) {
            playerIn.func_70634_a(playerIn.func_226277_ct_(), 300.0, playerIn.func_226281_cx_());
            TeleportHelper.findSurface(worldIn, playerIn, playerIn.func_233580_cy_());
            TeleportHelper.portalEffect(worldIn, (LivingEntity)playerIn);
            worldIn.func_184133_a(null, playerIn.func_233580_cy_(), SoundEvents.field_232710_ez_, SoundCategory.AMBIENT, 1.0f, 1.0f);
            playerIn.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 20);
            itemstack.func_96631_a(1, field_77697_d, null);
        }
    }

    private void spark(PlayerEntity playerIn) {
        World worldIn = playerIn.field_70170_p;
        BlockPos pos = playerIn.func_233580_cy_();
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), (SoundEvent)ModSounds.FIZZLE.get(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(field_77697_d.nextFloat() / 2.0f), 5.0E-5, (double)(field_77697_d.nextFloat() / 2.0f));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(field_77697_d.nextFloat() / 2.0f), 5.0E-5, (double)(field_77697_d.nextFloat() / 2.0f));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(field_77697_d.nextFloat() / 2.0f), 5.0E-5, (double)(field_77697_d.nextFloat() / 2.0f));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(field_77697_d.nextFloat() / 2.0f), 5.0E-5, (double)(field_77697_d.nextFloat() / 2.0f));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)(field_77697_d.nextFloat() / 2.0f), 5.0E-5, (double)(field_77697_d.nextFloat() / 2.0f));
    }
}

