/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldstrader.util;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TeleportHelper {
    private static final Random random = new Random();

    public static void attemptRandomTeleport(PlayerEntity playerIn, int range) {
        World worldIn = playerIn.field_70170_p;
        if (!worldIn.func_201670_d() && worldIn.func_234923_W_() == World.field_234918_g_) {
            int posZ;
            int posY;
            int posX = (int)((double)playerIn.func_233580_cy_().func_177958_n() + (random.nextDouble() - 0.5) * (double)range);
            BlockPos pos = new BlockPos(posX, posY = 300, posZ = (int)((double)playerIn.func_233580_cy_().func_177952_p() + (random.nextDouble() - 0.5) * (double)range));
            if (worldIn.func_226691_t_(pos).func_201856_r() == Biome.Category.OCEAN || worldIn.func_226691_t_(pos).func_201856_r() == Biome.Category.RIVER) {
                TeleportHelper.attemptRandomTeleport(playerIn, range);
            } else {
                playerIn.func_70634_a((double)posX, (double)posY, (double)posZ);
                TeleportHelper.findSurface(worldIn, playerIn, pos);
                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_232710_ez_, SoundCategory.NEUTRAL, 1.0f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    public static void findSurface(World worldIn, PlayerEntity playerIn, BlockPos pos) {
        int max = 300;
        for (int r = 1; r < max; ++r) {
            BlockPos blockpos = playerIn.func_233580_cy_().func_177979_c(r);
            if (!worldIn.func_180495_p(blockpos).func_200132_m() && worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150353_l && worldIn.func_180495_p(blockpos).func_177230_c() != Blocks.field_150355_j) continue;
            if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150355_j) {
                worldIn.func_175656_a(blockpos, Blocks.field_150343_Z.func_176223_P());
            }
            playerIn.func_70634_a((double)blockpos.func_177958_n(), (double)(blockpos.func_177956_o() + 1), (double)blockpos.func_177952_p());
            r = max;
        }
    }

    public static void returnHome(PlayerEntity playerIn) {
        World worldIn = playerIn.field_70170_p;
        if (!worldIn.func_201670_d() && worldIn.func_234923_W_() == World.field_234918_g_) {
            BlockPos bed = TeleportHelper.getBedPosition((ServerPlayerEntity)playerIn);
            if (bed != null) {
                playerIn.func_70634_a((double)bed.func_177958_n(), (double)bed.func_177956_o(), (double)bed.func_177952_p());
            } else {
                BlockPos spawn = TeleportHelper.getSpawnPosition((ServerPlayerEntity)playerIn);
                if (spawn != null) {
                    playerIn.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                } else {
                    playerIn.func_70634_a(0.0, 300.0, 0.0);
                    TeleportHelper.findSurface(worldIn, playerIn, playerIn.func_233580_cy_());
                }
            }
        }
    }

    private static BlockPos getBedPosition(ServerPlayerEntity player) {
        Optional bed = player.func_213374_dv();
        BlockPos bedPos = null;
        if (bed.isPresent()) {
            int x = ((BlockPos)bed.get()).func_177958_n();
            int y = ((BlockPos)bed.get()).func_177956_o();
            int z = ((BlockPos)bed.get()).func_177952_p();
            bedPos = new BlockPos(x, y, z);
        }
        return bedPos;
    }

    private static BlockPos getSpawnPosition(ServerPlayerEntity player) {
        BlockPos spawnPos = player.func_241140_K_();
        BlockPos spawn = null;
        if (spawnPos != null) {
            spawn = spawnPos;
        }
        return spawn;
    }

    public static void portalEffect(World world, LivingEntity livingEntity) {
        if (world.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, livingEntity.func_226282_d_(0.5), livingEntity.func_226279_cv_() - 0.25, livingEntity.func_226287_g_(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        }
    }
}

