/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilitySleepData {
    @CapabilityInject(value=ISleepData.class)
    public static final Capability<ISleepData> SLEEP_DATA_CAP = null;
    public static final ResourceLocation ID = new ResourceLocation("comforts", "sleep_data");
    private static final String WAKE_TAG = "wakeTime";
    private static final String TIRED_TAG = "tiredTime";
    private static final String SLEEP_TAG = "sleepTime";

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        CapabilityManager.INSTANCE.register(ISleepData.class);
    }

    public static LazyOptional<ISleepData> getCapability(Player player) {
        return player.getCapability(SLEEP_DATA_CAP);
    }

    public static class CapabilityEvents {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof Player) {
                evt.addCapability(ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public void onPlayerDeath(PlayerEvent.Clone evt) {
            if (evt.isWasDeath()) {
                Player player = evt.getPlayer();
                Player original = evt.getOriginal();
                original.revive();
                CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> CapabilitySleepData.getCapability(original).ifPresent(sleepdata::copyFrom));
            }
        }
    }

    public static interface ISleepData {
        public long getSleepTime();

        public void setSleepTime(long var1);

        public long getWakeTime();

        public void setWakeTime(long var1);

        public long getTiredTime();

        public void setTiredTime(long var1);

        public BlockPos getAutoSleepPos();

        public void setAutoSleepPos(BlockPos var1);

        public void copyFrom(ISleepData var1);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ISleepData> optional;
        final ISleepData data = new SleepDataWrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return SLEEP_DATA_CAP.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128356_(CapabilitySleepData.WAKE_TAG, this.data.getWakeTime());
            compound.m_128356_(CapabilitySleepData.TIRED_TAG, this.data.getTiredTime());
            compound.m_128356_(CapabilitySleepData.SLEEP_TAG, this.data.getSleepTime());
            return compound;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compound = (CompoundTag)nbt;
            this.data.setWakeTime(compound.m_128454_(CapabilitySleepData.WAKE_TAG));
            this.data.setTiredTime(compound.m_128454_(CapabilitySleepData.TIRED_TAG));
            this.data.setSleepTime(compound.m_128454_(CapabilitySleepData.SLEEP_TAG));
        }
    }

    public static class SleepDataWrapper
    implements ISleepData {
        long sleepTime = 0L;
        long wakeTime = 0L;
        long tiredTime = 0L;
        BlockPos autoSleepPos = null;

        @Override
        public long getSleepTime() {
            return this.sleepTime;
        }

        @Override
        public void setSleepTime(long time) {
            this.sleepTime = time;
        }

        @Override
        public long getWakeTime() {
            return this.wakeTime;
        }

        @Override
        public void setWakeTime(long time) {
            this.wakeTime = time;
        }

        @Override
        public long getTiredTime() {
            return this.tiredTime;
        }

        @Override
        public void setTiredTime(long time) {
            this.tiredTime = time;
        }

        @Override
        public BlockPos getAutoSleepPos() {
            return this.autoSleepPos;
        }

        @Override
        public void setAutoSleepPos(BlockPos pos) {
            this.autoSleepPos = pos;
        }

        @Override
        public void copyFrom(ISleepData other) {
            this.setSleepTime(other.getSleepTime());
            this.setTiredTime(other.getTiredTime());
            this.setWakeTime(other.getWakeTime());
        }
    }
}

