/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.provider.ProviderUtils;
import net.blay09.mods.cookingforblockheads.api.IKitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class KitchenMultiBlock
implements IKitchenMultiBlock {
    private static final List<class_2248> blockConnectors = new ArrayList<class_2248>();
    private final Set<class_2338> checkedPos = Sets.newHashSet();
    private final List<IKitchenItemProvider> itemProviderList = Lists.newArrayList();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = Lists.newArrayList();

    private KitchenMultiBlock(class_1937 level, class_2338 pos) {
        this.findNeighbourKitchenBlocks(level, pos, true);
    }

    public static KitchenMultiBlock buildFromLocation(class_1937 level, class_2338 pos) {
        return new KitchenMultiBlock(level, pos);
    }

    private void findNeighbourKitchenBlocks(class_1937 level, class_2338 pos, boolean extendedUpSearch) {
        for (class_2350 direction : class_2350.values()) {
            int upSearch = extendedUpSearch && direction == class_2350.field_11036 ? 2 : 1;
            for (int n = 1; n <= upSearch; ++n) {
                class_2338 position = pos.method_10079(direction, n);
                if (this.checkedPos.contains(position)) continue;
                this.checkedPos.add(position);
                class_2586 blockEntity = level.method_8321(position);
                if (blockEntity != null) {
                    IKitchenSmeltingProvider smeltingProvider;
                    IKitchenItemProvider itemProvider = (IKitchenItemProvider)ProviderUtils.getProvider((class_2586)blockEntity, IKitchenItemProvider.class);
                    if (itemProvider != null) {
                        this.itemProviderList.add(itemProvider);
                    }
                    if ((smeltingProvider = (IKitchenSmeltingProvider)ProviderUtils.getProvider((class_2586)blockEntity, IKitchenSmeltingProvider.class)) != null) {
                        this.smeltingProviderList.add(smeltingProvider);
                    }
                    if (itemProvider == null && smeltingProvider == null && ProviderUtils.getProvider((class_2586)blockEntity, IKitchenConnector.class) == null) continue;
                    this.findNeighbourKitchenBlocks(level, position, true);
                    continue;
                }
                class_2680 state = level.method_8320(position);
                if (state.method_26215() || !blockConnectors.contains(state.method_26204())) continue;
                this.findNeighbourKitchenBlocks(level, position, false);
            }
        }
    }

    public static void registerConnectorBlock(class_2248 block) {
        blockConnectors.add(block);
    }

    @Override
    public List<IKitchenItemProvider> getItemProviders(class_1661 playerInventory) {
        ArrayList sourceInventories = Lists.newArrayList();
        sourceInventories.addAll(this.itemProviderList);
        sourceInventories.add(new DefaultKitchenItemProvider((class_1263)playerInventory));
        return sourceInventories;
    }

    @Override
    public class_1799 smeltItem(class_1799 itemStack, int count) {
        IKitchenSmeltingProvider provider;
        class_1799 restStack = itemStack.method_7972().method_7971(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && !(restStack = (provider = iterator.next()).smeltItem(restStack)).method_7960()) {
        }
        return restStack;
    }

    public void trySmelt(class_1799 outputItem, class_1799 inputItem, class_1657 player, boolean stack) {
        if (inputItem.method_7960()) {
            return;
        }
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = this.getItemProviders(player.method_31548());
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> it.method_7962(inputItem) && count > 0, inputItem);
        for (IKitchenItemProvider itemProvider : inventories) {
            int amount;
            itemProvider.resetSimulation();
            int count2 = stack ? inputItem.method_7914() : 1;
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate, count2, inventories, requireBucket, false);
            if (sourceItem == null) continue;
            class_1799 sourceStack = sourceItem.getSourceStack();
            class_1799 restStack = this.smeltItem(sourceStack, amount = Math.min(sourceStack.method_7947(), count2));
            if (!restStack.method_7960()) {
                restStack = itemProvider.returnItemStack(restStack, sourceItem);
                if (!player.method_31548().method_7394(restStack)) {
                    player.method_7328(restStack, false);
                }
            }
            player.field_7512.method_7623();
            return;
        }
    }

    @Override
    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }
}

