/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class ToasterBlockEntity
extends BalmBlockEntity {
    private static final int UPDATE_INTERVAL = 20;
    private static final int TOAST_TICKS = 1200;
    private final DefaultContainer container = new DefaultContainer(2){

        public void method_5431() {
            ToasterBlockEntity.this.method_5431();
            ToasterBlockEntity.this.sync();
        }
    };
    private boolean isDirty;
    private int ticksSinceUpdate;
    private boolean active;
    private int toastTicks;

    public ToasterBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.toaster.get(), pos, state);
    }

    public boolean method_11004(int id, int type) {
        if (id == 0) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.toasterStart.get(), class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.toasterStop.get(), class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
            return true;
        }
        return super.method_11004(id, type);
    }

    public void method_11014(class_2487 tagCompound) {
        super.method_11014(tagCompound);
        this.container.deserialize(tagCompound.method_10562("ItemHandler"));
        this.active = tagCompound.method_10577("Active");
        this.toastTicks = tagCompound.method_10550("ToastTicks");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("ItemHandler", (class_2520)this.container.serialize());
        tag.method_10556("Active", this.active);
        tag.method_10569("ToastTicks", this.toastTicks);
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, ToasterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !level.field_9236) {
                for (int i = 0; i < this.container.method_5439(); ++i) {
                    class_1799 inputStack = this.container.method_5438(i);
                    if (inputStack.method_7960()) continue;
                    ToasterHandler toastHandler = CookingRegistry.getToasterHandler(inputStack);
                    class_1799 outputStack = toastHandler != null ? toastHandler.getToasterOutput(inputStack) : class_1799.field_8037;
                    outputStack = outputStack.method_7960() ? inputStack : outputStack.method_7972();
                    class_1542 itemEntity = new class_1542(level, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.75f), (double)((float)this.field_11867.method_10260() + 0.5f), outputStack);
                    itemEntity.method_18800(0.0, (double)0.1f, 0.0);
                    level.method_8649((class_1297)itemEntity);
                    this.container.method_5447(i, class_1799.field_8037);
                }
                this.setActive(false);
            }
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 1, 0);
        }
        this.field_11863.method_8427(this.field_11867, ModBlocks.toaster, 2, 0);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.isDirty = true;
        this.method_5431();
    }

    public boolean isActive() {
        return this.active;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public boolean isBurningToast() {
        class_2487 firstTag = this.container.method_5438(0).method_7969();
        class_2487 secondTag = this.container.method_5438(1).method_7969();
        return firstTag != null && firstTag.method_10577("CookingForBlockheadsToasted") || secondTag != null && secondTag.method_10577("CookingForBlockheadsToasted");
    }
}

