/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final DefaultContainer container = new DefaultContainer(27){

        public void method_5431() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.method_5431();
        }
    };
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((class_1263)this.container){
        private final class_1799 snowStack;
        private final class_1799 iceStack;
        {
            this.snowStack = new class_1799((class_1935)class_1802.field_8543);
            this.iceStack = new class_1799((class_1935)class_2246.field_10295);
        }

        @Nullable
        private SourceItem applyIceUnit(IngredientPredicate predicate, int maxAmount) {
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.snowStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((class_1799)this.snowStack, (int)maxAmount));
            }
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.iceStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((class_1799)this.iceStack, (int)maxAmount));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).method_7960() || CookingRegistry.isToolItem(it));
            }
            return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }

        @Override
        @Nullable
        public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).method_7960() || CookingRegistry.isToolItem(it));
            }
            return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator((class_2586)this, 1, 2);
    private class_2561 customName;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((class_3414)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((class_3414)ModSounds.fridgeClose.get());
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
        this.doorAnimator.update();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean method_11004(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.method_11004(id, type);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.container.deserialize(tag.method_10562("ItemHandler"));
        this.hasIceUpgrade = tag.method_10577("HasIceUpgrade");
        this.hasPreservationUpgrade = tag.method_10577("HasPreservationUpgrade");
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
        if (tag.method_10573("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.method_10577("IsForcedOpen"));
        }
        if (tag.method_10573("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.method_10571("NumPlayersUsing"));
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("ItemHandler", (class_2520)this.container.serialize());
        tag.method_10556("HasIceUpgrade", this.hasIceUpgrade);
        tag.method_10556("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag);
        tag.method_10556("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.method_10567("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        if (this.field_11863.method_8320(this.field_11867.method_10084()).method_26204() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.field_11863.method_8321(this.field_11867.method_10084());
        }
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_26204() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.field_11863.method_8321(this.field_11867.method_10074());
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.method_11002()) {
            return this;
        }
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_26204() instanceof FridgeBlock && (baseFridge = (FridgeBlockEntity)this.field_11863.method_8321(this.field_11867.method_10074())) != null) {
            return baseFridge;
        }
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public class_1263 getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new class_1263[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, 0, -1), this.field_11867.method_10069(2, 2, 2));
    }

    public void markDirtyAndUpdate() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, state, state, 3);
        this.method_5431();
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Override
    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.cookingforblockheads.fridge");
    }

    public class_1263 getContainer() {
        return this.container;
    }
}

